% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.functions.R
\name{rank.mbnma}
\alias{rank.mbnma}
\title{Rank parameter estimates}
\usage{
\method{rank}{mbnma}(x, params = NULL, direction = 1,
  level = "agent", to.rank = NULL, ...)
}
\arguments{
\item{x}{An object on which to apply the rank method}

\item{params}{A character vector of named parameters in the model that vary by either agent
or class (depending on the value assigned to \code{level}). If left as \code{NULL} (the default), then
ranking will be calculated for all available parameters that vary by agent/class.}

\item{direction}{Indicates whether negative responses are better (taking the
value \code{-1}) or positive responses are better (taking the value \code{1})}

\item{level}{Can be set to \code{"agent"} to rank across different agents or \code{"class"} to rank
across different classes.}

\item{to.rank}{A numeric vector containing the codes for the agents/classes you wish to rank.
If left \code{NULL} then all agents/classes (depending on the value assigned to \code{level}) in
the model will be ranked. Included codes must be greater than
\code{2} if placebo has been modelled, since placebo cannot be included in the ranking}

\item{...}{Arguments to be passed to methods}
}
\value{
An object of \code{class("mbnma.rank")} which is a list containing a summary data
frame, a matrix of rankings for each MCMC iteration, and a matrix of probabilities
that each agent has a particular rank, for each parameter that has been ranked.
}
\description{
Only parameters that vary by agent/class can be ranked.
}
\details{
Ranking cannot currently be performed on non-parametric dose-response MBNMA
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(HF2PPITT)

# Rank selected agents from a linear dose-response MBNMA
linear <- mbnma.run(network, fun="linear")
ranks <- rank(linear, to.rank=c("zolmitriptan", "eletriptan", "sumatriptan"))
summary(ranks)

# Rank only ED50 parameters from an Emax dose-response MBNMA
emax <- mbnma.emax(network, emax="rel", ed50="rel", method="random")
ranks <- rank(emax, params="d.ed50")
summary(ranks)


#### Ranking by class ####
# Generate some classes for the data
class.df <- HF2PPITT
class.df$class <- ifelse(class.df$agent=="placebo", "placebo", "active1")
class.df$class <- ifelse(class.df$agent=="eletriptan", "active2", class.df$class)
netclass <- mbnma.network(class.df)
emax <- mbnma.emax(netclass, emax="rel", ed50="rel", method="random",
            class.effect=list("ed50"="common"))

# Rank by class, with negative responses being "better"
ranks <- rank(emax, level="class", direction=-1)
print(ranks)

# Print and generate summary data frame for `mbnma.rank` object
summary(ranks)
print(ranks)

# Plot `mbnma.rank` object
plot(ranks)
}

}
