% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.jags.R
\name{mbnma.write}
\alias{mbnma.write}
\title{Write MBNMA dose-response model JAGS code}
\usage{
mbnma.write(
  fun = dpoly(degree = 1),
  method = "common",
  regress.mat = NULL,
  regress.effect = "common",
  sdscale = FALSE,
  cor = FALSE,
  cor.prior = "wishart",
  omega = NULL,
  om = list(rel = 5, abs = 10),
  class.effect = list(),
  UME = FALSE,
  likelihood = "binomial",
  link = NULL
)
}
\arguments{
\item{fun}{An object of \code{class("dosefun")} that specifies a functional form to be assigned to the
dose-response. See Details.}

\item{method}{Can take either \code{"common"} or \code{"random"} to indicate whether relative effects
should be modelled with between-study heterogeneity or not (see details).}

\item{regress.mat}{A Nstudy x Ncovariate design matrix of meta-regression covariates}

\item{regress.effect}{Indicates whether effect modification should be assumed to be
\code{"common"} (assumed to be equal versus Placebo throughout the network),
\code{"random"} (assumed to be exchangeable versus Placebo throughout the network),
\code{"agent"} (assumed to be equal versus Placebo within each agent), or
\code{"class"} (assumed to be equal versus Placebo within each class).}

\item{sdscale}{Logical object to indicate whether to write a model that specifies a reference SD
for standardising when modelling using Standardised Mean Differences. Specifying \code{sdscale=TRUE}
will therefore only modify the model if link function is set to SMD (\code{link="smd"}).}

\item{cor}{A boolean object that indicates whether correlation should be modelled
between relative effect dose-response parameters. This is
automatically set to \code{FALSE} if class effects are modelled or if multiple dose-response
functions are fitted.}

\item{cor.prior}{NOT CURRENTLY IN USE - indicates the prior distribution to use for the correlation/covariance
between relative effects. Must be kept as \code{"wishart"}}

\item{omega}{A scale matrix for the inverse-Wishart prior for the covariance matrix used
to model the correlation between dose-response parameters (see Details for dose-response functions). \code{omega} must
be a symmetric positive definite matrix with dimensions equal to the number of dose-response parameters modelled using
relative effects (\code{"rel"}). If left as \code{NULL} (the default) a diagonal matrix with elements equal to 100
is used.}

\item{om}{a list with two elements that report the maximum relative (\code{"rel"}) and maximum absolute (\code{"abs"}) efficacies
on the link scale.}

\item{class.effect}{A list of named strings that determines which dose-response
parameters to model with a class effect and what that effect should be
(\code{"common"} or \code{"random"}). Element names should match dose-response parameter names.
Note that assuming class effects on some dose-response parameters may be unreasonable if
the range of doses differ substantially across agents within a class.}

\item{UME}{A boolean object to indicate whether to fit an Unrelated Mean Effects model
that does not assume consistency and so can be used to test if the consistency
assumption is valid.}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{link}{A string indicating the link function to use in the model. Can take any link function
defined within JAGS (e.g. \code{"logit"}, \code{"log"}, \code{"probit"}, \code{"cloglog"}), be assigned the value \code{"identity"} for
an identity link function, or be assigned the value \code{"smd"} for modelling Standardised Mean Differences using an
identity link function. If left as \code{NULL} the link function will be automatically assigned based
on the likelihood.}
}
\value{
A single long character string containing the JAGS model generated
based on the arguments passed to the function.
}
\description{
Writes JAGS code for a Bayesian time-course model for model-based network
meta-analysis (MBNMA).
}
\details{
When relative effects are modelled on more than one dose-response parameter and
\code{cor = TRUE}, correlation between the dose-response parameters is automatically
estimated using a vague Wishart prior. This prior can be made slightly more informative
by specifying the relative scale of variances between the dose-response parameters using
\code{omega}. \code{cor} will automatically be set to \code{FALSE} if class effects are modelled.
}
\examples{
# Write model code for a model with an exponential dose-response function,
# with random treatment effects
model <- mbnma.write(fun=dexp(),
             method="random",
             likelihood="binomial",
             link="logit"
             )
names(model) <- NULL
print(model)

# Write model code for a model with an Emax dose-response function,
# relative effects modelled on Emax with a random effects model,
# a single parameter estimated for ED50 with a common effects model
model <- mbnma.write(fun=demax(emax="rel", ed50="common"),
             likelihood="normal",
             link="identity"
             )
names(model) <- NULL
print(model)

# Write model code for a model with an Emax dose-response function,
# relative effects modelled on Emax and ED50.
# Class effects modelled on ED50 with common effects
model <- mbnma.write(fun=demax(),
             likelihood="normal",
             link="identity",
             class.effect=list("ed50"="common")
             )
names(model) <- NULL
print(model)

# Write model code for a model with an Emax dose-response function,
# relative effects modelled on Emax and ED50 with a
# random effects model that automatically models a correlation between
# both parameters.
model <- mbnma.write(fun=demax(),
             method="random",
             likelihood="normal",
             link="identity",
             )
names(model) <- NULL
print(model)
}
