% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mb.network-class.R, R/prepare.functions.R
\name{plot.mb.network}
\alias{plot.mb.network}
\alias{mb.network}
\title{Create an \code{mb.network} object}
\usage{
\method{plot}{mb.network}(
  x,
  edge.scale = 1,
  label.distance = 0,
  level = "treatment",
  remove.loops = FALSE,
  v.color = "connect",
  v.scale = NULL,
  layout = igraph::in_circle(),
  legend = TRUE,
  legend.x = "bottomleft",
  legend.y = NULL,
  ...
)

mb.network(data.ab, reference = 1, description = "Network")
}
\arguments{
\item{x}{An object of class \code{mb.network}.}

\item{edge.scale}{A number to scale the thickness of connecting lines
(edges). Line thickness is proportional to the number of studies for a
given comparison. Set to \code{0} to make thickness equal for all comparisons.}

\item{label.distance}{A number scaling the distance of labels from the nodes
to improve readability. The labels will be directly on top of the nodes if
the default of \code{0} is used. Option only applicable if \code{layout_in_circle} is
set to \code{TRUE}.}

\item{level}{A string indicating whether nodes/facets should represent \code{treatment}
or \code{class} in the plot. Can be used to examine the expected impact of modelling
class/agent effects.}

\item{remove.loops}{A boolean value indicating whether to include loops that
indicate comparisons within a node.}

\item{v.color}{Can take either \code{"connect"} (the default) to indicate that nodes should
only be coloured if they are connected to the network reference treatment (indicates
network connectivity) or \code{"class"} to colour nodes by class (this requires that the
variable \code{class} be included in the dataset).}

\item{v.scale}{A number with which to scale the size of the nodes. If the variable \code{N}
(to indicate the numbers of participants at each observation) is included in the
dataset then the size of the nodes will be proportional to the number of participants
within a treatment/class in the network \emph{at the earliest time point reported in each study}.}

\item{layout}{An igraph layout specification. This is a function specifying an igraph
layout that determines the arrangement of the vertices (nodes). The default
\code{igraph::as_circle()} arranged vertices in a circle. Two other useful layouts for
network plots are: \code{igraph::as_star()}, \code{igraph::with_fr()}. Others can be found
in \code{\link[igraph]{layout_}}}

\item{legend}{A boolean value indicating whether or not to plot a legend with class names if \code{v.color="class"}}

\item{legend.x}{Can be either a string or a numerical x-coordinate indicating where the legend should be
plotted (see \code{\link[graphics]{legend}}).}

\item{legend.y}{A numerical y-coordinate indicating where the legend should be plotted - only required if \code{legend.x} is also
a numeric co-ordinate.}

\item{...}{Options for plotting in \code{igraph}.}

\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{y} Numeric data indicating the aggregate response for a given observation (e.g. mean)
\item \code{se} Numeric data indicating the standard error for a given observation
\item \code{treatment} Treatment identifiers (can be numeric, factor or character)
\item \code{class} An optional column indicating a particular class identifier. Observations with the same treatment
identifier must also have the same class identifier.
\item \code{n} An optional column indicating the number of participants used to calculate the
response at a given observation (required if modelling using Standardised Mean Differences)
}}

\item{reference}{A number or character (depending on the format of \code{treatment} within \code{data.ab})
indicating the reference treatment in the network (i.e. those for which estimated relative treatment
effects estimated by the model will be compared to).}

\item{description}{Optional. Short description of the network.}
}
\value{
An object of \code{class("mb.network")} which is a list containing:
\itemize{
\item \code{description} A short description of the network
\item \code{data.ab} A data frame containing the arm-level network data (treatment identifiers will have
been recoded to a sequential numeric code)
\item \code{treatments} A character vector indicating the treatment identifiers that correspond to the
new treatment codes.
\item \code{classes} A character vector indicating the class identifiers (if included in the original data)
that correspond to the new class codes.
}
}
\description{
Creates an object of \code{class("mb.network")}. Various MBNMA functions can subsequently be applied
to this object.
}
\details{
The S3 method \code{plot()} on an \code{mb.network} object generates a
network plot that shows how different treatments are connected within the
network via study comparisons. This can be used to identify how direct and
indirect evidence are informing different treatment comparisons. Depends on
\code{\link[igraph]{igraph}}.

Missing values (\code{NA}) cannot be included in the dataset. Studies must have a baseline
measurement and more than a single follow-up time (unless change from baseline data are being used).
Data must be present for all arms within a study at each follow-up time.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Generate a network plot
}}

\examples{

\donttest{

# Create an mb.network object from the data
network <- mb.network(osteopain)

# Arrange network plot in a star with the reference treatment in the centre
plot(network, layout=igraph::as_star())

# Generate a network plot at the class level that removes loops indicating comparisons
#within a node
goutnet <- mb.network(goutSUA_CFB)
plot(goutnet, level="class", remove.loops=TRUE)

# Generate a network plot at the treatment level that colours nodes by class
plot(goutnet, v.color="class", remove.loops=TRUE)

# Plot network in which node size is proportional to number of participants
alognet <- mb.network(alog_pcfb)
plot(alognet, v.scale=2)

}

# Using the osteoarthritis dataset
print(osteopain)

# Define network
network <- mb.network(osteopain, description="Osteoarthritis Dataset")

# Define network with different network reference treatment
network <- mb.network(osteopain, reference="Ce_200")


# Using the alogliptin dataset
network <- mb.network(alog_pcfb, description="Alogliptin Dataset")

# Examine networks
print(network)
plot(network)

}
