% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_index.R
\name{row_index}
\alias{row_index}
\title{A function indexing the rows of A}
\usage{
row_index(bS, M, S, xS)
}
\arguments{
\item{bS}{A binary matrix specifying the set of observation patterns. Each row encodes a single pattern.}

\item{M}{A vector of positive integers giving the alphabet sizes of the discrete variables.}

\item{S}{An integer indicating which observation pattern is of interest.}

\item{xS}{An element of the observation space of the specified observation pattern.}
}
\value{
A positive integer no larger than the cardinality of the joint space uniquely identifying \code{x}.
}
\description{
A map from the observation space to an index set.
}
\examples{
bS=matrix(c(1,1,0, 1,0,1, 0,1,1),byrow=TRUE,ncol=3)
M=c(2,2,2)
row_index(bS,M,1,c(1,1))
row_index(bS,M,2,c(1,1))
row_index(bS,M,3,c(1,1))

bS=matrix(c(1,1,0, 1,0,1, 0,1,1),byrow=TRUE,ncol=3)
M=c(4,3,2)
row_index(bS,M,1,c(1,1))
row_index(bS,M,1,c(2,1))
row_index(bS,M,1,c(3,1))
row_index(bS,M,1,c(4,1))
row_index(bS,M,1,c(1,2))
row_index(bS,M,1,c(2,2))

}
