% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mestimate.R
\name{mestimate}
\alias{mestimate}
\title{Moment estimator}
\usage{
mestimate(x, y)
}
\arguments{
\item{x}{input vector, of dimension nobs x nvars; each row is an observation
vector.}

\item{y}{quantitative response variable of length nobs}
}
\value{
Returns a list of 7 variables: \item{p.full }{The p-value for the
test of the full set of variables selected by the lasso (based on the OLS
estimates)} \item{ols.selected }{A vector of the indices of the non-zero
variables selected by \code{glmnet} sorted from (numerically) highest to
lowest based on their ols test statistic.} \item{p.maxols }{The p-value for
the maximum of the OLS test statistics} \item{lasso.selected }{A vector of
the indices of the non-zero variables selected by \code{glmnet} sorted from
(numerically) highest to lowest based on their absolute lasso coefficients.}
\item{p.maxlasso }{The p-value for the maximum of the lasso test statistics}
\item{lambda.orig }{The value of lambda used in the computations} \item{B
}{The number of permutations used}
}
\description{
To be filled out at a later date
}
\examples{

n <- 1000
p <- rbinom(n, size=1, prob=.20)
x <- rnorm(n)
y <- rnorm(n, mean=x)*p

mestimate(x, y)

}
\seealso{
\code{lm}
}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk}
}
\keyword{~htests}
