# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Shift a Vector
#'
#' Shift a population vector by one day and insert the new population.
#' This was written to remove the dependency "binhf".
#'
#' @param popVector List of population vectors of length(Tegg+Tlarva+Tpupa)
#' @param newPop Vector of length equal to the number of genotypes
#'
shiftAndUpdatePopVector <- function(popVector, newPop) {
    invisible(.Call('_MGDrivE_shiftAndUpdatePopVector', PACKAGE = 'MGDrivE', popVector, newPop))
}

#' Dirichlet Distribution
#'
#' Make a single draw from a dirichlet distribution with the shape parameter
#' one. This replaces the MCMCpack rDirichlet function, which was wholly written
#' in R.
#'
#' @param migrationPoint Vector of weights for draws. Must be positive.
#'
rDirichlet <- function(migrationPoint) {
    .Call('_MGDrivE_rDirichlet', PACKAGE = 'MGDrivE', migrationPoint)
}

#' Quantiles Function
#'
#' Calculate the given quantiles of a matrix.
#'
#' @usage quantileC(Trials, Probs)
#'
#' @param Trials Integer matrix to calculate quantiles over
#' @param Probs Vector of quantiles
#'
#' @details This function calculates the given quantiles over the rows of an
#' integer matrix. It uses method 8 of the stat::quantiles() function. It gives
#' the same result, to numerical accuracy, and is designed to handle matrix input.
#' It is only designed to work on integer matrices!
#'
#' @return Numeric Matrix
#'
quantileC <- function(Trials, Probs) {
    .Call('_MGDrivE_quantileC', PACKAGE = 'MGDrivE', Trials, Probs)
}

#' Calculate Geodesic Distance - Cosine Method
#'
#' This function calculates geodesic distance using the cosing method.
#'
#' @param latLongs Two column matrix of latitudes/longitudes
#' @param r Earth radius. Default is WGS-84 radius
#'
#' @examples
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # cosine distance formula
#' distMat = calcCos(latLongs = latLong)
#'
#' @export
calcCos <- function(latLongs, r = 6378137) {
    .Call('_MGDrivE_calcCos', PACKAGE = 'MGDrivE', latLongs, r)
}

#' Calculate Geodesic Distance - Haversine Method
#'
#' This function calculates geodesic distance using the haversine method.
#'
#' @param latLongs Two column matrix of latitudes/longitudes
#' @param r Earth radius. Default is WGS-84 radius
#'
#' @examples
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # haversine distance formula
#' distMat = calcHaversine(latLongs = latLong)
#'
#' @export
calcHaversine <- function(latLongs, r = 6378137) {
    .Call('_MGDrivE_calcHaversine', PACKAGE = 'MGDrivE', latLongs, r)
}

#' Calculate Geodesic Distance - Vincenty Sphere Method
#'
#' This function calculates geodesic distance using the Vincenty sphere method.
#'
#' @param latLongs Two column matrix of latitudes/longitudes
#' @param r Earth radius. Default is WGS-84 radius
#'
#' @examples
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # Vincenty Sphere  distance formula
#' distMat = calcVinSph(latLongs = latLong)
#'
#' @export
calcVinSph <- function(latLongs, r = 6378137) {
    .Call('_MGDrivE_calcVinSph', PACKAGE = 'MGDrivE', latLongs, r)
}

#' Calculate Geodesic Distance - Vincenty Ellipsoid Method
#'
#' This function calculates geodesic distance using the original Vincenty Ellipsoid method.
#'
#' @param latLongs Two column matrix of latitudes/longitudes
#' @param a Equatorial radius of the earth, default is WGS-84 radius
#' @param b Polar radius of the earth, default is WGS-84 radius
#' @param f Flattening or inverse eccentricity, default eccentricity is WGS-84
#' @param eps Convergence criteria
#' @param iter Naximum number of iterations to attempt convergence
#'
#' @examples
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # Vincenty Ellipsoid  distance formula
#' distMat = calcVinEll(latLongs = latLong)
#'
#' @export
calcVinEll <- function(latLongs, a = 6378137, b = 6356752.3142, f = 1.0/298.257223563, eps = 1e-12, iter = 100) {
    .Call('_MGDrivE_calcVinEll', PACKAGE = 'MGDrivE', latLongs, a, b, f, eps, iter)
}

#' Calculate Lognormal Stochastic Matrix
#'
#' Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}},
#' calculate a stochastic matrix where one step movement probabilities follow a lognormal density.
#'
#' @param distMat distance matrix from \code{\link[MGDrivE]{calcVinEll}}
#' @param meanlog log mean of \code{\link[stats]{Lognormal}} distribution
#' @param sdlog log standard deviation of \code{\link[stats]{Lognormal}} distribution
#'
#' @examples
#' # setup distance matrix
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # Vincenty Ellipsoid  distance formula
#' distMat = calcVinEll(latLongs = latLong)
#'
#' # calculate lognormal distribution over distances
#' #  mean and standard deviation are just for example
#' kernMat = calcLognormalKernel(distMat = distMat, meanlog = 100, sdlog = 10)
#'
#' @export
calcLognormalKernel <- function(distMat, meanlog, sdlog) {
    .Call('_MGDrivE_calcLognormalKernel', PACKAGE = 'MGDrivE', distMat, meanlog, sdlog)
}

#' Calculate Gamma Stochastic Matrix
#'
#' Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}}, calculate a
#' stochastic matrix where one step movement probabilities follow a gamma density.
#'
#' @param distMat distance matrix from \code{\link[MGDrivE]{calcVinEll}}
#' @param shape shape parameter of \code{\link[stats]{GammaDist}} distribution
#' @param rate rate parameter of \code{\link[stats]{GammaDist}} distribution
#'
#' @examples
#' # setup distance matrix
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # Vincenty Ellipsoid  distance formula
#' distMat = calcVinEll(latLongs = latLong)
#'
#' # calculate gamma distribution over distances
#' #  shape and rate are just for example
#' kernMat = calcGammaKernel(distMat = distMat, shape = 1, rate = 1)
#'
#' @export
calcGammaKernel <- function(distMat, shape, rate) {
    .Call('_MGDrivE_calcGammaKernel', PACKAGE = 'MGDrivE', distMat, shape, rate)
}

#' Calculate Exponential Stochastic Matrix
#'
#' Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}}, calculate a
#' stochastic matrix where one step movement probabilities follow an exponential density.
#'
#' @param distMat distance matrix from \code{\link[MGDrivE]{calcVinEll}}
#' @param rate rate parameter of \code{\link[stats]{Exponential}} distribution
#'
#' @examples
#' # setup distance matrix
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # Vincenty Ellipsoid  distance formula
#' distMat = calcVinEll(latLongs = latLong)
#'
#' # calculate exponential distribution over distances
#' #  rate is just for example
#' kernMat = calcExpKernel(distMat = distMat, rate = 10)
#'
#' @export
calcExpKernel <- function(distMat, rate) {
    .Call('_MGDrivE_calcExpKernel', PACKAGE = 'MGDrivE', distMat, rate)
}

#' Calculate Hurdle Exponential Stochastic Matrix
#'
#' Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}}, calculate a
#' stochastic matrix where one step movement probabilities follow an zero-truncated
#' exponential density with a point mass at zero.
#'
#' @param distMat distance matrix from \code{\link[MGDrivE]{calcVinEll}}
#' @param rate rate parameter of \code{\link[stats]{Exponential}} distribution
#' @param pi point mass at zero
#'
#' @examples
#' # setup distance matrix
#' # two-column matrix with latitude/longitude, in degrees
#' latLong = cbind(runif(n = 5, min = 0, max = 90),
#'                 runif(n = 5, min = 0, max = 180))
#'
#' # Vincenty Ellipsoid  distance formula
#' distMat = calcVinEll(latLongs = latLong)
#'
#' # calculate hurdle exponential distribution over distances
#' #  rate and point mass are just for example
#' kernMat = calcHurdleExpKernel(distMat = distMat, rate = 10, pi = 1000)
#'
#' @export
calcHurdleExpKernel <- function(distMat, rate, pi) {
    .Call('_MGDrivE_calcHurdleExpKernel', PACKAGE = 'MGDrivE', distMat, rate, pi)
}

