% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-analysis.R
\name{summarize_stats_CSV}
\alias{summarize_stats_CSV}
\title{Summary Statistics for MGDrivE2}
\usage{
summarize_stats_CSV(
  read_dir,
  write_dir = read_dir,
  mean = TRUE,
  quantiles = NULL,
  spn_P,
  tmax,
  dt,
  rem_file = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{read_dir}{Directory to find repetition folders in}

\item{write_dir}{Directory to write output}

\item{mean}{Boolean, calculate mean or not. Default is TRUE}

\item{quantiles}{Vector of quantiles to calculate. Default is NULL}

\item{spn_P}{Places object, see details}

\item{tmax}{The final time to end simulation}

\item{dt}{The time-step at which to return output (\strong{not} the time-step of the sampling algorithm)}

\item{rem_file}{Remove original output? Default is FALSE}

\item{verbose}{Chatty? Default is TRUE}
}
\value{
Writes output to files in write_dir
}
\description{
This function reads in all repetitions for each patch and calculates either
the mean, quantiles, or both. User chooses the quantiles, up to 4 decimal places,
and enters them as a vector. Quantiles are calculated empirically. (order does not matter)  \cr
}
\details{
Given the read_dir, this function assumes the follow file structure: \cr
\itemize{
\item read_dir
\itemize{
\item repetition 1
\itemize{
\item M_0001.csv
\item M_0002.csv
\item FS_0001.csv
\item FS_0001.csv
\item ... \cr
}
\item repetition 2
\itemize{
\item M_0001.csv
\item M_0002.csv
\item FS_0001.csv
\item FS_0001.csv
\item ... \cr
}
\item repetition 3
\item ... \cr
}
}

The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

\code{t0}, \code{tt}, \code{dt} define the first sampling time, the last sampling
time, and each sampling time in-between.

Output files are *.csv and contain the mean or quantile in the file name, e.g.
{stage}\emph{Mean}(patchNum).csv and {stage}\emph{Quantile}(quantNum)_(patchNum).csv.

For more details about using this function to process CSV output see:
\code{vignette("data-analysis", package = "MGDrivE2")}
}
