% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_Imputation.R
\name{GenImputation}
\alias{GenImputation}
\title{Generate Imputation}
\usage{
GenImputation(fit)
}
\arguments{
\item{fit}{Fitted model.}
}
\value{
Numeric matrix with missing values imputed.
}
\description{
Generates a stochastic imputation of a data set from a fitted data set.
}
\examples{
set.seed(100)

# Generate data and introduce missingness.
data <- rGMM(n = 25, d = 2, k = 1)
data[1, 1] <- NA
data[2, 2] <- NA
data[3, ] <- NA 

# Fit GMM.
fit <- FitGMM(data)

# Generate imputation.
imputed <- GenImputation(fit)
}
