% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDRSU.R
\name{MBH.p.adjust}
\alias{MBH.p.adjust}
\title{The adjusted p-values for Modified Benjamini-Hochberg (BH) step-up FDR controlling procedure.}
\usage{
MBH.p.adjust(p,p.set)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{p.set}{a list of numeric vectors, where each vector is the vector of all attainable p-values containing the available p-value for the corresponding hypothesis.}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \eqn{p}).
}
\description{
The function for calculating the adjusted p-values based on original available p-values and all attaianble p-values.
}
\examples{
p <- c(pbinom(1,8,0.5),pbinom(1,5,0.75),pbinom(1,6,0.6))
p.set <-list(pbinom(0:8,8,0.5),pbinom(0:5,5,0.75),pbinom(0:6,6,0.6))
MBH.p.adjust(p,p.set)
}
\author{
Yalin Zhu
}
\references{
Benjamini, Y., and Hochberg, Y. (1995).
 Controlling the false discovery rate: a practical and powerful approach to multiple testing.
 \emph{Journal of the Royal Statistical Society Series B}, \strong{57}: 289-300.
}

