% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEce.R
\name{MLEce}
\alias{MLEce}
\alias{print.MLEce}
\title{Calculating a value of MLEce according to a distribution}
\usage{
MLEce(data, distrib, boots = 1000, CI.alpha = 0.05, ...)

\method{print}{MLEce}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{data}{a numeric vector or matrix.}

\item{distrib}{a character string "name" naming a distribution for which the corresponding density function dname
and the corresponding distribution function pname must be classically defined.}

\item{boots}{a number of iteration for calculating CI-parametric intervals.}

\item{CI.alpha}{a significance level of confidence intervals. default is 0.05.}

\item{...}{not used, but exists because of the compatibility.}

\item{x}{an object of class "MLEce".}

\item{digits}{a numeric number of significant digits.}
}
\value{
an object of class “MLEce”. It is a list with the following components:
\item{estimation}{the parameter estimates.}
\item{distribution }{a character string of a distribution assuming that data set comes from.}
\item{stat_summary}{a numeric vector with min, 1st quantile, median, 3rd quantile, and max.}
\item{CI}{a matrix with confidence intervals of Estimates obtained by CI-parametric bootstrapping.}
\item{n}{a numeric value of data length.}
\item{data}{the data set.}
}
\description{
Provide a function that numerically computes the closed-form estimator which is asymptotically efficient and
can be computed faster than the maximum likelihood estimator.
}
\details{
The closed-form estimation procedure is based on root n-consistent estimators and a Fisher scoring step or a Newton step on the loglikelihood function.
The estimator is obtained by solving the linear equation By E.L. Lehmann.
This estimator follows the multivariate normal distribution with mean vector of 0 and variance matrix of inverse of Fisher Information matrix and
has the properties of a multivariate normal distribution.
}
\examples{
datt = rBiGam(100, c(1,4,5))
res = MLEce(datt, "BiGam", boots = 50)
}
