% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopGradMMD.R
\name{BiCopGradMMD}
\alias{BiCopGradMMD}
\title{Computation of the gradient of the MMD criterion
for parametric bivariate copulas models}
\usage{
BiCopGradMMD(
  u1,
  u2,
  family,
  tau,
  par = NULL,
  par2 = 0,
  kernel = "gaussian.KG",
  gamma = 0.95,
  alpha = 1,
  epsilon = 1e-04,
  method = "QMCV",
  quasiRNG = "sobol",
  ndrawings = 10
)
}
\arguments{
\item{u1}{vector of observations of the first coordinate, in \eqn{[0,1]}.}

\item{u2}{vector of observations of the second coordinate, in \eqn{[0,1]}.}

\item{family}{the chosen family of copulas
(see the documentation of the class \code{VineCopula::\link[VineCopula]{BiCop}()}
for the available families).}

\item{tau}{the copula family can be parametrized by the parameter \code{par}
or by Kendall's tau. This function assumes a Kendall tau parametrization.
Thus, the user can choose the value of Kendall tau at
which the stochastic gradient should be computed.}

\item{par}{if different from \code{NULL},
the user must instead of \code{tau} specify the corresponding parameter \code{par}.
The value of \code{tau} is then ignored.}

\item{par2}{value for the second parameter, if any. (Works only for Student copula).}

\item{kernel}{the kernel used in the MMD distance:
 it can be a function taking in parameter \code{(u1, u2, v1, v2, gamma, alpha)}
 or a name giving the kernel to use in the list:
 \itemize{
   \item \code{gaussian}: Gaussian kernel \eqn{k(x,y) = \exp(-\|\frac{x-y}{\gamma}\|_2^2)
   }{k(x,y) = exp( - || (x-y) / gamma ||_2^2)}
   \item \code{exp.l2}: \eqn{k(x,y) = \exp(-\|\frac{x-y}{\gamma}\|_2)
   }{k(x,y) = exp( - || (x-y) / gamma ||_2)}
   \item \code{exp.l1}: \eqn{k(x,y) = \exp(-\|\frac{x-y}{\gamma}\|_1)
   }{k(x,y) = exp( - || (x-y) / gamma ||_1)}
   \item \code{inv.l2}: \eqn{k(x,y) = 1/(1+\|\frac{x-y}{\gamma}\|_2)^\alpha
   }{k(x,y) = 1 / ( 1 + || (x-y) / gamma ||_2 )^\alpha}
   \item \code{inv.l1}: \eqn{k(x,y) = 1/(1+\|\frac{x-y}{\gamma}\|_1)^\alpha
   }{k(x,y) = 1 / ( 1 + || (x-y) / gamma ||_1 )^\alpha}
 }
Each of these names can receive the suffix ".KG", such as "gaussian.KG"
to indicates that the kernel \eqn{k(x,y)} is replaced by
\eqn{k(\Phi^{-1}(x) , \Phi^{-1}(y))} where \eqn{\Phi^{-1}} denotes the quantile
function of the standard Normal distribution.}

\item{gamma}{parameter \eqn{\gamma} to be used in the kernel.}

\item{alpha}{parameter \eqn{\alpha} to be used in the kernel, if any.}

\item{epsilon}{the differential of \code{VineCopula::\link[VineCopula]{BiCopTau2Par}()}
is computed thanks to a finite difference with increment \code{epsilon}.}

\item{method}{the method of computing the stochastic gradient:
\itemize{
  \item \code{MC}: classical Monte-Carlo with \code{ndrawings} replications.
  \item \code{QMCV}: usual Monte-Carlo on U with \code{ndrawings} replications,
    quasi Monte-Carlo on V.
}}

\item{quasiRNG}{a function giving the quasi-random points in \eqn{[0,1]^2} or a name giving
the method to use in the list: \itemize{
 \item \code{sobol}: use of the Sobol sequence
   implemented in \code{randtoolbox::\link[randtoolbox:quasiRNG]{sobol}}
 \item \code{halton}: use of the Halton sequence
   implemented in \code{randtoolbox::\link[randtoolbox:quasiRNG]{halton}}
 \item \code{torus}: use of the Torus sequence
   implemented in \code{randtoolbox::\link[randtoolbox:quasiRNG]{torus}}
}}

\item{ndrawings}{number of replicas of the stochastic estimate of the gradient drawn
at each step. The gradient is computed using the average of these replicas.}
}
\value{
the value of the gradient.
}
\description{
This function computes a stochastic estimate of the gradient of the MMD criterion
for parametric estimation of bidimensional copula family.
The main arguments are the two vectors of observations, and the copula family.
The family is parametrized as in \code{VineCopula::\link[VineCopula]{BiCop}()},
using the Kendall's tau instead of the first parameter.
This function is used by \code{\link{BiCopEstMMD}()} to perform parameter estimation
via MMD minimization.
}
\examples{
# Simulation from a bivariate Gaussian copula with correlation 0.5.
dataSampled = VineCopula::BiCopSim(N = 500, family = 1, par = 0.5)

# computation of the gradient of the MMD criteria at different points
# Gradient is small at the true parameter
BiCopGradMMD(dataSampled[,1], dataSampled[,2], family = 1, par = 0.5)
# Gradient is negative when below the parameter
BiCopGradMMD(dataSampled[,1], dataSampled[,2], family = 1, par = 0.1)
# and positive when above
BiCopGradMMD(dataSampled[,1], dataSampled[,2], family = 1, par = 0.8)

}
\references{
Alquier, P., Chérief-Abdellatif, B.-E., Derumigny, A., and Fermanian, J.D. (2020).
Estimation of copulas via Maximum Mean Discrepancy.
ArXiv preprint \href{https://arxiv.org/abs/2010.00408}{arxiv:2010.00408}
}
\seealso{
\code{\link{BiCopEstMMD}()} for the estimation of parametric bivariate copulas by
stochastic gradient descent on the MMD criteria.
}
