% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_identifier.R
\name{k_identifier}
\alias{k_identifier}
\title{Identify the number of components k}
\usage{
k_identifier(data, T = 1000)
}
\arguments{
\item{data}{- an array with dimension c(n,p,d). data[i,j,c] denotes the number of trials occurs in i-th observation, j-th variable and c-th categories.}

\item{T}{- number of iterations in Gibbs sampler, default value is 1000. T should be an even number for 'burn-in'. The estimates are computed by the second-half iterations.}
}
\value{
k - number of components
}
\description{
This function is applied when number of components k is unknown and number of trials m > 2k -1. Missing data is allowed in dataset.
This function identifies the number of components. Then if needed, parameters could be estimated by function FinMix().
}
\note{
m - number of trials, i.e., m = sum(data[i,j,]). Here m are identical for all i and j.
m > 2k - 1 is a condition that guarantees identifiability (Elmore and Wang, 2003).

n - number of observations

p - number of variables

d - number of categories. Here d are identical for all variables.
}
\examples{
## IncompleteData example
data("IncompleteData")
k_identifier(data = IncompleteData$data)
}
\references{
[1] Elmore, Ryan, and Shaoli Wang. "ldentifiability and Estimation in Finite Mixture Models with Multinomial Components."
}

