% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{predint}
\alias{predint}
\title{Classification of cases as typical and deviant using a prediction
interval.}
\usage{
predint(lmobject, piwidth = 0.95)
}
\arguments{
\item{lmobject}{Object generated with \code{\link[stats]{lm}}}

\item{piwidth}{Width of the prediction interval (default is 0.95).}
}
\value{
A dataframe with the observed outcome, fitted outcome,
upper and lower bound of the \% prediction interval and classification
of cases as typical or deviant.
}
\description{
Case are designated as typical (= well predicted) and deviant
(= badly predicted) based on the prediction interval. The x\% prediction
interval represents the range that we expect to include
x\% of outcome values in repeated samples. For example, a 95\%
prediction interval ranging from 0-5 conveys that 95\% of future outcome
values will be in the range of 0-5. If the observed outcome
is inside the prediction interval, the case is classified (or designated) as
 typical and as deviant otherwise.
}
\details{
Proposed by Rohlfing, Ingo and Peter Starke (2013):
Building on Solid Ground: Robust Case Selection in Multi-Method Research.
*Swiss Political Science Review* 19 (4): 492-512.
(\url{https://doi.org/10.1111/spsr.12052})
}
\examples{
df <- lm(mpg ~ disp + wt, data = mtcars)
predint(df, piwidth = 0.9)

}
