% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMotifSet.R
\name{addMotifSet}
\alias{addMotifSet}
\title{\code{addMotifSet}}
\usage{
addMotifSet(SE_Object, pwms, w = 7, returnObj = TRUE, motifSetName = "Motifs")
}
\arguments{
\item{SE_Object}{your MOCHA SummarizedExperiment. Requires Genome
AnnotationDbi object within the metadata added by getSampleTileMatrix}

\item{pwms}{a pwms object for the motif database. Either PFMatrix,
PFMatrixList, PWMatrix, or PWMatrixLis'}

\item{w}{the width for motifmatchr}

\item{returnObj}{if TRUE, return the modified SE_Object with motif set added
to metadata (default). If FALSE, return the motifs from motifmatchr.}

\item{motifSetName}{name of the motifList in the SE_object's metadata if
returnObj=TRUE. Default is 'Motifs'.}
}
\value{
the modified SE_Object with motifs added to the metadata
}
\description{
\code{addMotifSet}Identify motifs within peakset
}
\examples{
\dontrun{
# load a curated motif set from library(chromVARmotifs)
# included with ArchR installation
data(human_pwms_v2)
SE_with_motifs <- addMotifSet(
  SE_Object,
  pwms = human_pwms_v2,
  returnObj = TRUE, motifSetName = "Motifs", w = 7
)
}

}
