% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLMEM.R
\name{pilotLMEM}
\alias{pilotLMEM}
\title{Execute a pilot run of single linear model on a subset of data}
\usage{
pilotLMEM(
  ExperimentObj,
  assayName,
  modelFormula,
  pilotIndices = 1:10,
  verbose = FALSE
)
}
\arguments{
\item{ExperimentObj}{A SummarizedExperiment-type object generated from
chromVAR, makePseudobulkRNA, or other. Objects from getSampleTileMatrix can work,
but we recommend runZIGLMM for those objects, not runLMEM>}

\item{assayName}{a character string, matching the name of an assay within the SummarizedExperiment.
The assay named will be used for modeling.}

\item{modelFormula}{The formula to use with lmerTest::lmer, in the
format (exp ~ factors). All factors must be found in column names
of the ExperimentObj metadata.}

\item{pilotIndices}{A vector of integers defining the subset of
the ExperimentObj matrix. Default is 1:10.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
modelList a list of outputs from lmerTest::lmer
}
\description{
`r lifecycle::badge("deprecated")`
  This function is deprecated - improved modeling functions can be found in 
  the package "ChAI" at https://github.com/aifimmunology/ChAI
  \code{pilotLMEM} Runs linear mixed-effects modeling for
  continuous, non-zero inflated data using \code{\link[lmerTest]{lmer}}
}
