% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\alias{get_tile}
\title{Download MODIS snow cover data (version 6) from the National Snow and Ice Data Center.}
\usage{
download_data(date, sat = "MYD10A1", h = 10, v = 10, printFTP = FALSE,
  ...)

get_tile(ftp, tile, progress = FALSE, clean = TRUE)
}
\arguments{
\item{date}{Day for which snow data should be downloaded as \code{Date}, \code{POSIXct}, or \code{POSIXlt}.}

\item{sat}{Satellite mission used. Currently Terra (\code{"MYD10A1"}) and Aqua (\code{"MOD10A1"}) are supported.}

\item{h}{Horizontal tile number, see also details.}

\item{v}{Vertical tile number, see also details.}

\item{printFTP}{If \code{TRUE}, the FTP address where the data are downloaded is printed.}

\item{...}{Further arguments passed to \code{get_tile()}.}

\item{ftp}{Address of the repository.}

\item{tile}{Name of the tile.}

\item{progress}{Indicates whether or not progress is displayed.}

\item{clean}{Indidcates whether or not temporary files are deleted.}
}
\value{
The function returns an object of the class \code{RasterLayer} with the following cell values:
\itemize{
 \item 0-100 NDSI snow cover
 \item 200 missing data
 \item 201 no decision
 \item 211 night
 \item 237 inland water
 \item 239 ocean
 \item 250 cloud
 \item 254 detector saturated
 \item 255 fill
}
but see also the documentation for the \emph{NDSI_SNOW_COVER} \href{http://nsidc.org/data/MOD10A1}{here}.
}
\description{
\code{download_data} is the main function to download a scene given the correct tile, date and satellite.

\code{get_tile} is a helper function that actually downloads a tile. Supplied with a correct \code{ftp} address and \code{tile} the function downloads the MODIS tile, and transforms the coordinate reference system to latlong (EPSG:4326).
}
\details{
When downloading the data, the correct tile has to be specified. At the moment there is no automated way to find the tile. This means that the user has to consult the \href{http://landweb.nascom.nasa.gov/developers/is_tiles/is_bound_10deg.txt}{MODIS land grid} to find the correct tile. Alternatively the \href{http://landweb.nascom.nasa.gov/cgi-bin/developer/tilemap.cgi}{MODIS tile calculator} may be used.
}
\examples{
\dontrun{
# Download MODIS snow data for a central europe h = 18 and v = 5 for the 1 of January 2016
dat <- download_data(lubridate::ymd("2016-01-01"), h = 18, v = 5)
class(dat)
raster::plot(dat)
}
}
\references{
When using the MODIS snow cover data, please acknowledge the data appropriately by
\enumerate{
  \item reading the \href{http://nsidc.org/about/use_copyright.html}{use and copyright}
  \item citing the original data: \emph{Hall, D. K. and G. A. Riggs. 2016. MODIS/[Terra/Aqua] Snow Cover Daily L3 Global 500m Grid, Version 6. [Indicate subset used]. Boulder, Colorado USA. NASA National Snow and Ice Data Center Distributed Active Archive Center. doi: http://dx.doi.org/10.5067/MODIS/MOD10A1.006. [Date Accessed].}
}
}

