% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_read.R
\name{mt_read}
\alias{mt_read}
\title{Read a MODISTools data file}
\usage{
mt_read(filename)
}
\arguments{
\item{filename}{a MODISTools data file}
}
\value{
A nested data structure including site meta-data, the full
header and the data as a `data.frame()`.
}
\description{
Read a MODISTools data file into a nested structure of class MODISTools.
}
\examples{

\donttest{
# download data
mt_subset(product = "MOD11A2",
           lat = 40,
           lon = -110,
           band = "LST_Day_1km",
           start = "2004-01-01",
           end = "2004-03-31",
           internal = FALSE)

# read file
df <- mt_read(paste0(tempdir(),
               "/sitename_MOD11A2_2004-01-01_2004-03-31.csv"))
print(df)
}
}
\keyword{IO}
\keyword{series,}
\keyword{time}
