% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraint_vbr.R
\name{constraint_vbr}
\alias{constraint_vbr}
\title{"Violation-based Ranking" constraint handling method for MOEA/D}
\usage{
constraint_vbr(bigZ, bigV, type = c("ts", "sr", "vt"), pf = NULL, ...)
}
\arguments{
\item{bigZ}{Matrix of scalarized objective values for each neighborhood and
the incumbent solution (generated by \code{\link[=scalarize_values]{scalarize_values()}})}

\item{bigV}{Matrix of violation values for each neighborhood and the
incumbent solution (generated in \code{\link[=order_neighborhood]{order_neighborhood()}})}

\item{type}{type of \code{c(x)} function to use (see \code{c(x) Criteria} for details).}

\item{pf}{probability parameter for type = "sr" (ignored in other modes).}

\item{...}{other parameters (unused, included for compatibility with
generic call)}
}
\value{
\code{[ N x (T+1) ]} matrix of preference indices. Each row \code{i} contains
a permutation of \code{{1, 2, ..., (T+1)}}, where \code{1,...,T} correspond
to the solutions contained in the neighborhood of the i-th subproblem,
\code{B[i, ]}, and \code{T+1} corresponds to the incumbent solution for that
subproblem. The order of the permutation is defined by the specific strategy
defined by the input variable \code{type}).
}
\description{
Uses the Violation-based Ranking handling method to generate a
preference index for the MOEADr framework.
}
\details{
This function calculates the preference index of a set of neighborhoods
based on the "violation-based ranking" (VBR) constraint handling method. Please
see \code{\link[=order_neighborhood]{order_neighborhood()}} for more information on the preference index
matrix.

The VBR strategy generalizes some well-known methods for handling constraints
in population-based metaheuristics (see Section \code{c(x) Criteria}).
This strategy essentially ranks points within for a given subproblem based on
their aggregated function value (\code{f^{agg}(x|w_i)}) or their total constraint
violation (\code{v(x)}). Specific variations of this strategy differ on the
criteria for using one or the other.

The value used for ranking a given point \code{x} can be summarized as:

\tabular{lll}{
Violation  \tab | c(x) criterion \tab | Rank using: \cr
\code{v(x) = 0} \tab | \code{c(x) = *}     \tab | \code{f^{agg}(x|w_i)}\cr
\code{v(x) > 0} \tab | \code{c(x) == TRUE} \tab | \code{f^{agg}(x|w_i)}\cr
\code{v(x) > 0} \tab | \code{c(x) == FALSE}\tab | \code{v(x)}      \cr
}

Points compared according to their \code{f^{agg}(x|w_i)} values (i.e., feasible
points and those for which \code{c(x) = TRUE}) are ranked first (i.e., receive
ranks between \code{1} and \code{n_{feas}}, where \code{n_{feas}} is the
number of feasible points in the i-th neighborhood), with points that are
compared according to their \code{v(x)} values receiving ranks between
\code{(n_{feas} + 1)} and \code{T + 1} (\code{T} being the size of the neighborhood. The \code{+1}
comes from including the incumbent solution in the comparison).
}
\section{c(x) Criteria}{

Specific variations of the VBR differ on how the criterion c(x) is
implemented. Three variants are currently implemented in the MOEADr package:

\tabular{lll}{
Method                                 \tab | ID            \tab | \code{c(x)} \cr
Tournament Selection \code{[Deb2000]}       \tab | \code{$type = "ts"}\tab | \code{FALSE}\cr
Stochastic Ranking \code{[Runarsson2000]}   \tab | \code{$type = "sr"}\tab | \code{runif() < pf}\cr
Violation Threshold \code{[Asafuddoula2014]}\tab | \code{$type = "vt"}\tab | \code{v(x) < eps_v^i}\cr
}

where \eqn{pf \in [0,1]} is a user-defined parameter for the "sr" method, and
\code{eps_v^i} is subproblem-dependent, adaptive quantity calculated internally
in the routine (see \code{[Asafuddoula2014]} and \code{[Campelo2017]} for details).
}

\section{Using an External Archive}{

For types "sr" and "vt", it is possible for the algorithm to lose feasible
solutions during its update step, since there is a non-zero probability of
unfeasible solutions replacing feasible ones. In these cases, it is
recommended to set the \code{\link[=moead]{moead()}} parameter \code{update$UseArchive = TRUE}, so
that an external archive is built with the best feasible solutions found for
each subproblem.
}

\section{References}{

\code{[Deb2000]} K. Deb,
"An efficient constraint handling method for genetic algorithm",
Computer Methods in Applied Mechanics and Engieering 186(2–4):311–338, 2000.

\code{[Runarsson2000]} T. Runarsson, X. Yao,
"Stochastic ranking for constrained evolutionary optimization",
IEEE Transactions on Evolutionary Computation4(3):284–294, 2000.

\code{[Asafuddoula2014]} M. Asafuddoula, T. Ray, R. Sarker, K. Alam,
"An adaptive constraint handling approach embedded MOEA/D,”
2012 IEEE Congress on Evolutionary Computation (CEC).

\code{[Campelo2017]} F. Campelo, L.S. Batista, C. Aranha,
"A Component-Wise Perspective on Multiobjective Evolutionary Algorithms
based on Decomposition". In preparation, 2017.
}

