% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variation_localsearch.R
\name{variation_localsearch}
\alias{variation_localsearch}
\title{Local search Operators}
\usage{
variation_localsearch(...)
}
\arguments{
\item{...}{arguments to be passed down to the specific \code{ls_}\strong{xyz}\code{()}
functions. A list of available local search methods can be generated by
\code{\link[=get_localsearch_methods]{get_localsearch_methods()}}. Consult the documentation of the specific
functions for details.}
}
\value{
Either a matrix \code{Xls} containing the modified points (points
that did not undergo local search are indicated as NA in this output matrix),
or a list object containing the \code{Xls} matrix and an integer \code{nfe}, informing
how many additional function evaluations were performed by the local search
operator. The specific output is defined by the \code{ls_}\strong{xyz}\code{()} method used.
}
\description{
Local search operators for the MOEA/D
}
\details{
This routine calls the local search operator for the MOEADr package, as part
of the call to \code{\link[=perform_variation]{perform_variation()}}. This operator requires its entry
in the variation stack (see Section \code{Variation Operators} of \code{\link[=moead]{moead()}})
to contain the following fields:
\itemize{
\item \code{name = "localsearch"}
\item \code{type} (see \code{\link[=get_localsearch_methods]{get_localsearch_methods()}} for details)
\item \code{gamma.ls} (optional): probability of application of local search to a
given subproblem at any given iteration (numeric between 0 and 1)
\item \code{tau.ls} (optional): period of application of local search to each
subproblem (positive integer)
\item \code{trunc.x} (optional): logical flag for truncating the results of the
local search operator to the limits defined by \code{problem$xmin},
\code{problem$xmax} (logical). Defaults to \code{TRUE}.
}

Whenever local search is triggered for a given subproblem, it cancels
all other variation operators \emph{for that subproblem} and is executed directly
on the incumbent solution.

This routine is intended to be used internally by \code{\link[=perform_variation]{perform_variation()}},
and should not be called directly by the user.
}
