% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.z.z.R
\name{d.z.z}
\alias{d.z.z}
\title{d from z-statistic for Z-test}
\usage{
d.z.z(z, sig = NA, n, a = 0.05)
}
\arguments{
\item{z}{z statistic}

\item{sig}{population standard deviation}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
The effect size (Cohen's d) with associated confidence intervals and
relevant statistics.

\item{d}{effect size}
\item{dlow}{lower level confidence interval d value}
\item{dhigh}{upper level confidence interval d value}
\item{sigma}{sample size}
\item{z}{sig stats}
\item{p}{p-value}
\item{n}{sample size}
\item{estimate}{the d statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the Z-statistic in APA style for markdown printing}
}
\description{
This function displays d for Z-tests when all you have is the z-statistic.
The normal confidence interval is also provided if you have sigma.
If sigma is left blank, then you will not see a confidence interval.
}
\details{
To calculate d, z is divided by the square root of N.

d = z / sqrt(N)

\href{https://www.aggieerin.com/shiny-server/tests/zz.html}{Learn more on our example page.}
}
\examples{

#A recent study suggested that students (N = 100) learning
#statistics improved their test scores with the use of
#visual aids (Z = 2.5). The population standard deviation is 4.

#You can type in the numbers directly as shown below,
#or refer to your dataset within the function.

    d.z.z(z = 2.5, sig = 4, n = 100, a = .05)

    d.z.z(z = 2.5, n = 100, a = .05)

    d.z.z(2.5, 4, 100, .05)
}
\keyword{effect}
\keyword{size,}
\keyword{z-test}
