% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{penalty1}
\alias{penalty1}
\title{penalty1 enables the adding of a large penalty as one approaches 1.0}
\usage{
penalty1(x)
}
\arguments{
\item{x}{the parameter value that potentially incurs a penalty}
}
\value{
a single value as a penalty to be added to a Log-Likelihood or SSQ
}
\description{
penalty1 allows for the option of adding a large penalty as
    a parameter approaches 1.0 and moves to become larger than 1. For 
    example, when fitting a surplus production model sometimes the 
    optimal mathematical model fit can occur by implying catches greater
    than available biomass, implying harvest rates > 1.0. By adding a 
    large penalty to such values and adding those to the likelihood 
    such strange outcomes can be avoided. This will accept a single
    value or a vector.
}
\examples{
 x <- c(0.5,0.8,0.88,0.9,0.98,0.99,1.01)
 round(cbind(x,penalty1(x)),4)
}
