% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{fabens}
\alias{fabens}
\title{fabens calculates predicted growth increment for tagging data}
\usage{
fabens(par, indat, initL = "l1", delT = "dt")
}
\arguments{
\item{par}{a vector of at least Linf, and K from the von Bertalanffy 
growth curve}

\item{indat}{the matrix or data.frame of data columns containing at
least the initial lengths and the deltaT, time intervals between
tag release and recapture.}

\item{initL}{column name of the initial lengths within indat, 
default="l1"}

\item{delT}{column name of the time interval, deltaT, within indat,
default="dt"}
}
\value{
a vector of predicted growth increments
}
\description{
fabens requires at least two parameters, Linf and K from
    the von Bertalanffy growth curve in a vector, as well as the 
    initial length and the change in time between tag release and 
    recapture. It then calculates the expected growth increment.
}
\examples{
 data(blackisland)
 oldpar <- par(no.readonly=TRUE)
 plot(blackisland$l1,blackisland$dl,type="p",pch=16,
 xlab="Initial Length mm",ylab="Growth Increment mm",
 panel.first=grid())
 abline(h=0)
 param <- c(170, 0.3, 4.0) # Linf, K, sigma
 predDL <- fabens(param,blackisland,initL="l1",delT="dt")
 lines(blackisland$l1,predDL,col=2,lwd=2)  
 par(oldpar) 
}
