% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{parasympt}
\alias{parasympt}
\title{parasympt generates N vectors from a multi-variate normal}
\usage{
parasympt(bestmod, N)
}
\arguments{
\item{bestmod}{the output from nlm containing the optimal parameters in
log-space, and the hessian}

\item{N}{the number of parameter vectors to be sampled from the multi-
variate normal defined by the optimal parameters and the inverse of
the hessian (the variance-covariance matrix).}
}
\value{
an N x numpar matrix of parameter vectors
}
\description{
parasympt generates N vectors from a multi-variate normal
    distribution for a surplus production model. This can be used 
    when estimating the uncertainty around an spm fit, or when 
    conducting projections from a model fit while attempting to 
    account for uncertainty. Use of this function requires the 
    mvnnorm package. It could be generalized to suit any model. It is 
    designed for use only with models fitted using maximum likelihood.
}
\examples{
  data(abdat)
  schf <- FALSE
  param <- log(c(r=0.3,K=11500,Binit=3300,sigma=0.05))
  bestmod <- nlm(f=negLL1,p=param,funk=simpspm,logobs=log(abdat$cpue),
                 indat=abdat,typsize=magnitude(param),iterlim=1000,
                 schaefer=schf,hessian = TRUE)
  out <- spm(bestmod$estimate,indat=abdat,schaefer=schf)
  matpar <- parasympt(bestmod,1000)
  head(matpar,15)
  pairs(matpar)
}
