% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensSpec.R
\name{SensSpec}
\alias{SensSpec}
\title{Calculate sensitivity and specificity}
\usage{
SensSpec(
  data,
  Modality,
  Reader,
  Case,
  D,
  Y,
  percentage = FALSE,
  digits = max(1L, getOption("digits") - 3L)
)
}
\arguments{
\item{data}{A data frame in which contains the modality identifiers (\code{Modality}), the reader identifiers (\code{Reader}), the case identifiers (\code{Case}), the true disease status (\code{D}), and the binary diagnostic test result (\code{Y}).}

\item{Modality}{Variable of the modality identifiers.}

\item{Reader}{Variable of the reader identifiers.}

\item{Case}{Variable of the case identifiers.}

\item{D}{Variable of the true disease status. It should be set the value to 1 for cases diseased and to 0 for those non-diseased.}

\item{Y}{Variable of the binary diagnostic test result. It should be set the value to 1 for cases diagnosed as positive and to 0 for those diagnosed as negative.}

\item{percentage}{Whether to report results as decimals or percentage points. Default: \code{FALSE}.}

\item{digits}{Number of significant digits. Default: \code{max(1L, getOption("digits") - 3L)}.}
}
\value{
An object of class \code{SensSpec}. The object is a data.frame with the following components:
\item{Overall Result}{Overall sensitivity and specificity}
\item{Modality-specific Result}{Modality-specific sensitivity and specificity}
\item{Reader-specific Modality-specific Result}{Modality- and reader-specific sensitivity and specificity}
\item{digits}{The number of significant digits}
The results for the \code{SensSpec} are printed with the \code{\link[MRMCbinary]{print.SensSpec}} function.
}
\description{
\code{SensSpec()} is the function that calculates overall sensitivity and specificity, modality-specific sensitivity and specificity, and modality- and reader-specific sensitivity and specificity.
}
\examples{
## Load example data
data(VanDyke)

## Return the first parts of an object
head(VanDyke)

## Extract unique modalities
unique(VanDyke$treatment)

## Extract Unique readers
unique(VanDyke$reader)

## Create binary test results (Y_ijk)
VanDyke$Y <- as.numeric(VanDyke$rating >= 3)

## Example usage of SensSpec function:
# Report results as decimals
senspe_result1 <- SensSpec(data = VanDyke, Modality = treatment,
                           Reader = reader, Case = case,
                           D = truth, Y = Y, percentage = FALSE, digits = 3)

# Report results as percentage points
senspe_result2 <- SensSpec(data = VanDyke, Modality = treatment,
                           Reader = reader, Case = case,
                           D = truth, Y = Y, percentage = TRUE, digits = 1)

}
\references{
Yerushalmy, J. (1947). Statistical Problems in Assessing Methods of Medical Diagnosis, with Special Reference to X-Ray Techniques. \emph{Public Health Reports (1896-1970)}, 62(40), 1432–1449.
}
\seealso{
\code{\link[MRMCbinary]{print.SensSpec}}
}
\keyword{methods}
