\name{mcmc.szbsvar}
\alias{mcmc.szbsvar}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Gibbs sampler for coefficients of a B-SVAR model}
\description{
  Draws a posterior sample of the reduced form coefficients for a
  Bayesian SVAR model
}
\usage{
mcmc.szbsvar(varobj, A0.posterior)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{varobj}{ A B-SVAR object created by \code{\link{szbsvar}} }
  \item{A0.posterior}{ A posterior sample object generated by
    \code{\link{gibbs.A0}}}
}
\details{
  This function draws the parameters from the Bayesian SVAR model
  described by Waggoner and Zha (2003).  The details can be found in
  \code{\link{szbsvar}}.    The draws are done for the SVAR
  model and then translated into the reduced form parameters.
}
\value{

  A list of the class "mcmc.bsvar.posterior" with the following components:
  \item{ A0.posterior}{ \eqn{m \times m \times N2}{m x m x N2} array of
    the posterior matrices \eqn{A_0}{A(0)}.}
  \item{ B.sample}{ \eqn{N2 \times ncoef}{N2 x ncoef} matrix of the
    reduced form coefficients for the SVAR.}
  
}
\references{
  Waggoner, Daniel F. and Tao A. Zha.  2003. "A Gibbs sampler for
  structural vector autoregressions" \emph{Journal of Economic Dynamics
  \& Control}. 28:349--366.
 }
\author{ Patrick T. Brandt }
\note{ }

\seealso{ \code{\link{szbsvar}} }
\examples{
\dontrun{
varobj <- szbsvar(Y, p, z = NULL, lambda0, lambda1, lambda3, lambda4,
                  lambda5, mu5, mu6, ident, qm = 4)
posterior <- mcmc.szbsvar(varobj, N1, N2)
}
}
\keyword{ ts }% at least one, from doc/KEYWORDS
\keyword{ regression }% __ONLY ONE__ keyword per line
