% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS2OM.R
\name{SS2OM}
\alias{SS2OM}
\title{Reads MLE estimates from Stock Synthesis file structure into an operating model using package r4ss.}
\usage{
SS2OM(
  SSdir,
  nsim = 48,
  proyears = 50,
  reps = 1,
  maxF = 3,
  seed = 1,
  interval = 1,
  Obs = DLMtool::Generic_Obs,
  Imp = DLMtool::Perfect_Imp,
  import_mov = TRUE,
  gender = 1:2,
  age_rec = 1,
  silent = FALSE,
  Name = "OM generated by SS2OM function",
  Source = "No source provided",
  Author = "No author provided",
  report = FALSE,
  filename = "SS2OM",
  dir = tempdir(),
  open_file = TRUE,
  ...
)
}
\arguments{
\item{SSdir}{A folder with Stock Synthesis input and output files in it.}

\item{nsim}{The number of simulations to take for parameters with uncertainty (for OM@cpars custom parameters).}

\item{proyears}{The number of projection years for MSE}

\item{reps}{The number of stochastic replicates within each simulation in the operating model.}

\item{maxF}{The maximum allowable F in the operating model.}

\item{seed}{The random seed for the operating model.}

\item{interval}{The interval at which management procedures will update the management advice in \link[DLMtool]{runMSE}, e.g., 1 = annual updates.}

\item{Obs}{The observation model (class Obs). This function only updates the catch and index observation error.}

\item{Imp}{The implementation model (class Imp). This function does not update implementation parameters.}

\item{import_mov}{Logical, whether to import movement matrix from the assessment.}

\item{gender}{An integer that indexes the sex for importing life history parameters (1 = usually female, 2 = usually male, 1:2 = mean across both sexes).}

\item{age_rec}{Integer for the age of recruitment. The default is 1 for DLMtool operating models. Generally, should not be changed.}

\item{silent}{Whether to silence messages to the console.}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{Author}{Who did the assessment}

\item{report}{Logical, if TRUE, the function will run \link[DLMtool]{runMSE} to generate historical data from the operating model
to compare against SS output. A markdown report will be generated.}

\item{filename}{If \code{report = TRUE}, character string for the name of the markdown and HTML files.}

\item{dir}{If \code{report = TRUE}, the directory in which the markdown and HTML files will be saved.}

\item{open_file}{If \code{report = TRUE}, whether the HTML document is opened after it is rendered.}

\item{...}{Arguments to pass to \link[r4ss]{SS_output}.}
}
\value{
An object of class OM.
}
\description{
A function that uses the file location of a fitted SS3 model including input files to population the
various slots of an operating model with MLE parameter estimates. The function mainly populates the Stock and Fleet portions
of the operating model; the user still needs to parameterize most of the observation and implementation portions of the operating model.
}
\details{
The function generally uses values from the terminal year of the assessment for most life history parameters (maturity, M, etc). This function
does detect time-varying growth in the assessment and uses annual length/weight-at-age for historical years.
Selectivity is derived from the F-at-age matrix.
}
\note{
Currently supports versions of r4ss on CRAN (v.1.24) and Github (v.1.34-38).
}
\seealso{
\link{SS2Data}
}
\author{
T. Carruthers and Q. Huynh
}
