% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_functions.R
\name{Dom}
\alias{Dom}
\title{Determine dominate MPs}
\usage{
Dom(MSEobj, ..., PMlist = NULL, Refs = NULL, Yrs = NULL)
}
\arguments{
\item{MSEobj}{An object of class \code{MSE}}

\item{...}{Names of Performance Metrics (PMs), or other arguments to \code{TradePlot}.
First PM is recycled if number of PMs is not even}

\item{PMlist}{Optional list of PM names. Overrides any supplied in ... above}

\item{Refs}{An optional named list (matching the PM names) with numeric values to override the default \code{Ref} values.}

\item{Yrs}{An optional named list (matching the PM names) with numeric values to override the default \code{Yrs} values.}
}
\value{
A named list of length 2 with a character vector of non-dominated MPs in \code{MPs} and
a data.frame of dominated MPs and the names of the relevant dominated MPs in \code{DomMPs}
}
\description{
MPs that perform worse than comparable MPs across all performance metrics are considered 'dominated' as
other options are always preferable.
}
\details{
The \code{Dom} function compares the probabilities calculated in the performance metric
(\code{PM}) functions and determines the MPs that have a lower probability across all PMs compared
to other MPs of the same management type (e.g., size limit, TAC, etc).
Consequently, it is important that all \code{PM} functions are constructed so that higher probabilities = better performance
(e.g, \code{PNOF} is the probability of NOT overfishing)
}
\examples{
\dontrun{
MSE <- runMSE(MPs=NA) # run all MPs
Nondom <- Dom(MSE, "P10", "LTY", "PNOF")
# Non-dominated MPs
Nondom$MPs

# Dominated MPs
Nondom$DomMPs

}

}
\author{
A. Hordyk
}
