% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MSYCalcs}
\alias{MSYCalcs}
\title{Internal function to calculate MSY Reference Points}
\usage{
MSYCalcs(
  logF,
  M_at_Age,
  Wt_at_Age,
  Mat_at_Age,
  V_at_Age,
  maxage,
  R0x,
  SRrelx,
  hx,
  opt = 1L,
  plusgroup = 1L
)
}
\arguments{
\item{logF}{log fishing mortality}

\item{M_at_Age}{Vector of M-at-age}

\item{Wt_at_Age}{Vector of weight-at-age}

\item{Mat_at_Age}{Vector of maturity-at-age}

\item{V_at_Age}{Vector of selectivity-at-age}

\item{maxage}{Maximum age}

\item{R0x}{R0 for this simulation}

\item{SRrelx}{SRR type for this simulation. Use 3 for per-recruit calculations, i.e. constant recruitment.}

\item{hx}{numeric. Steepness value for this simulation}

\item{opt}{Option. 1 = return -Yield, 2= return all MSY calcs}

\item{plusgroup}{Integer. Default = 0 = no plus-group. Use 1 to include a plus-group}
}
\value{
See \code{opt}
}
\description{
Internal function to calculate MSY Reference Points
}
