#include "SingleRegime.h"
#include "sGARCH.h"
#include "Normal.h"
#include "Ged.h"
#include "Student.h"
#include "Symmetric.h"
#include "Skewed.h"
//===========================================================================//
//===========================================================================//
//================================== sGARCH ==================================//
//===========================================================================//
//===========================================================================//

typedef SingleRegime<sGARCH<Symmetric<Normal> > > sGARCH_norm;
typedef SingleRegime<sGARCH<Skewed<Normal> > > sGARCH_snorm;
typedef SingleRegime<sGARCH<Symmetric<Student> > > sGARCH_std;
typedef SingleRegime<sGARCH<Skewed<Student> > > sGARCH_sstd;
typedef SingleRegime<sGARCH<Symmetric<Ged> > > sGARCH_ged;
typedef SingleRegime<sGARCH<Skewed<Ged> > > sGARCH_sged;

RCPP_MODULE(sGARCH) {
  // sGARCH-norm-symmetric
  class_<sGARCH_norm>("sGARCH_norm")
      .constructor()
      .field("name", &sGARCH_norm::name)
      .field("theta0", &sGARCH_norm::theta0)
      .field("Sigma0", &sGARCH_norm::Sigma0)
      .field("label", &sGARCH_norm::label)
      .field("lower", &sGARCH_norm::lower)
      .field("upper", &sGARCH_norm::upper)
      .field("ineq_lb", &sGARCH_norm::ineq_lb)
      .field("ineq_ub", &sGARCH_norm::ineq_ub)
      .field("NbParams", &sGARCH_norm::NbParams)
      .field("NbParamsModel", &sGARCH_norm::NbParamsModel)
      .method("f_sim", &sGARCH_norm::f_sim)
      .method("f_pdf", &sGARCH_norm::f_pdf)
      .method("f_pdf_its", &sGARCH_norm::f_pdf_its)
      .method("f_cdf", &sGARCH_norm::f_cdf)
      .method("f_cdf_its", &sGARCH_norm::f_cdf_its)
      .method("f_simAhead", &sGARCH_norm::f_simAhead)
      .method("f_get_sd", &sGARCH_norm::get_sd)
      .method("f_set_sd", &sGARCH_norm::set_sd)
      .method("f_get_mean", &sGARCH_norm::get_mean)
      .method("f_set_mean", &sGARCH_norm::set_mean)
      .method("f_rnd", &sGARCH_norm::f_rnd)
      .method("calc_ht", &sGARCH_norm::calc_ht)
      .method("eval_model", &sGARCH_norm::eval_model)
      .method("ineq_func", &sGARCH_norm::ineq_func)
      .method("f_unc_vol", &sGARCH_norm::f_unc_vol);
  // sGARCH-std-symmetric
  class_<sGARCH_std>("sGARCH_std")
      .constructor()
      .field("name", &sGARCH_std::name)
      .field("theta0", &sGARCH_std::theta0)
      .field("Sigma0", &sGARCH_std::Sigma0)
      .field("label", &sGARCH_std::label)
      .field("lower", &sGARCH_std::lower)
      .field("upper", &sGARCH_std::upper)
      .field("ineq_lb", &sGARCH_std::ineq_lb)
      .field("ineq_ub", &sGARCH_std::ineq_ub)
      .field("NbParams", &sGARCH_std::NbParams)
      .field("NbParamsModel", &sGARCH_std::NbParamsModel)
      .method("f_sim", &sGARCH_std::f_sim)
      .method("f_pdf", &sGARCH_std::f_pdf)
      .method("f_pdf_its", &sGARCH_std::f_pdf_its)
      .method("f_cdf", &sGARCH_std::f_cdf)
      .method("f_cdf_its", &sGARCH_std::f_cdf_its)
      .method("f_simAhead", &sGARCH_std::f_simAhead)
      .method("f_get_sd", &sGARCH_std::get_sd)
      .method("f_set_sd", &sGARCH_std::set_sd)
      .method("f_get_mean", &sGARCH_std::get_mean)
      .method("f_set_mean", &sGARCH_std::set_mean)
      .method("f_rnd", &sGARCH_std::f_rnd)
      .method("calc_ht", &sGARCH_std::calc_ht)
      .method("eval_model", &sGARCH_std::eval_model)
      .method("ineq_func", &sGARCH_std::ineq_func)
      .method("f_unc_vol", &sGARCH_std::f_unc_vol);
  // sGARCH-ged-symmetric
  class_<sGARCH_ged>("sGARCH_ged")
      .constructor()
      .field("name", &sGARCH_ged::name)
      .field("theta0", &sGARCH_ged::theta0)
      .field("Sigma0", &sGARCH_ged::Sigma0)
      .field("label", &sGARCH_ged::label)
      .field("lower", &sGARCH_ged::lower)
      .field("upper", &sGARCH_ged::upper)
      .field("ineq_lb", &sGARCH_ged::ineq_lb)
      .field("ineq_ub", &sGARCH_ged::ineq_ub)
      .field("NbParams", &sGARCH_ged::NbParams)
      .field("NbParamsModel", &sGARCH_ged::NbParamsModel)
      .method("f_sim", &sGARCH_ged::f_sim)
      .method("f_pdf", &sGARCH_ged::f_pdf)
      .method("f_pdf_its", &sGARCH_ged::f_pdf_its)
      .method("f_cdf", &sGARCH_ged::f_cdf)
      .method("f_cdf_its", &sGARCH_ged::f_cdf_its)
      .method("f_simAhead", &sGARCH_ged::f_simAhead)
      .method("f_get_sd", &sGARCH_ged::get_sd)
      .method("f_set_sd", &sGARCH_ged::set_sd)
      .method("f_get_mean", &sGARCH_ged::get_mean)
      .method("f_set_mean", &sGARCH_ged::set_mean)
      .method("f_rnd", &sGARCH_ged::f_rnd)
      .method("calc_ht", &sGARCH_ged::calc_ht)
      .method("eval_model", &sGARCH_ged::eval_model)
      .method("ineq_func", &sGARCH_ged::ineq_func)
      .method("f_unc_vol", &sGARCH_ged::f_unc_vol);

  // sGARCH-norm-skew
  class_<sGARCH_snorm>("sGARCH_snorm")
      .constructor()
      .field("name", &sGARCH_snorm::name)
      .field("theta0", &sGARCH_snorm::theta0)
      .field("Sigma0", &sGARCH_snorm::Sigma0)
      .field("label", &sGARCH_snorm::label)
      .field("lower", &sGARCH_snorm::lower)
      .field("upper", &sGARCH_snorm::upper)
      .field("ineq_lb", &sGARCH_snorm::ineq_lb)
      .field("ineq_ub", &sGARCH_snorm::ineq_ub)
      .field("NbParams", &sGARCH_snorm::NbParams)
      .field("NbParamsModel", &sGARCH_snorm::NbParamsModel)
      .method("f_sim", &sGARCH_snorm::f_sim)
      .method("f_pdf", &sGARCH_snorm::f_pdf)
      .method("f_pdf_its", &sGARCH_snorm::f_pdf_its)
      .method("f_cdf", &sGARCH_snorm::f_cdf)
      .method("f_cdf_its", &sGARCH_snorm::f_cdf_its)
      .method("f_simAhead", &sGARCH_snorm::f_simAhead)
      .method("f_get_sd", &sGARCH_snorm::get_sd)
      .method("f_set_sd", &sGARCH_snorm::set_sd)
      .method("f_get_mean", &sGARCH_snorm::get_mean)
      .method("f_set_mean", &sGARCH_snorm::set_mean)
      .method("f_rnd", &sGARCH_snorm::f_rnd)
      .method("calc_ht", &sGARCH_snorm::calc_ht)
      .method("eval_model", &sGARCH_snorm::eval_model)
      .method("ineq_func", &sGARCH_snorm::ineq_func)
      .method("f_unc_vol", &sGARCH_snorm::f_unc_vol);
  // sGARCH-std-skew
  class_<sGARCH_sstd>("sGARCH_sstd")
      .constructor()
      .field("name", &sGARCH_sstd::name)
      .field("theta0", &sGARCH_sstd::theta0)
      .field("Sigma0", &sGARCH_sstd::Sigma0)
      .field("label", &sGARCH_sstd::label)
      .field("lower", &sGARCH_sstd::lower)
      .field("upper", &sGARCH_sstd::upper)
      .field("ineq_lb", &sGARCH_sstd::ineq_lb)
      .field("ineq_ub", &sGARCH_sstd::ineq_ub)
      .field("NbParams", &sGARCH_sstd::NbParams)
      .field("NbParamsModel", &sGARCH_sstd::NbParamsModel)
      .method("f_sim", &sGARCH_sstd::f_sim)
      .method("f_pdf", &sGARCH_sstd::f_pdf)
      .method("f_pdf_its", &sGARCH_sstd::f_pdf_its)
      .method("f_cdf", &sGARCH_sstd::f_cdf)
      .method("f_cdf_its", &sGARCH_sstd::f_cdf_its)
      .method("f_simAhead", &sGARCH_sstd::f_simAhead)
      .method("f_get_sd", &sGARCH_sstd::get_sd)
      .method("f_set_sd", &sGARCH_sstd::set_sd)
      .method("f_get_mean", &sGARCH_sstd::get_mean)
      .method("f_set_mean", &sGARCH_sstd::set_mean)
      .method("f_rnd", &sGARCH_sstd::f_rnd)
      .method("calc_ht", &sGARCH_sstd::calc_ht)
      .method("eval_model", &sGARCH_sstd::eval_model)
      .method("ineq_func", &sGARCH_sstd::ineq_func)
      .method("f_unc_vol", &sGARCH_sstd::f_unc_vol);
  // sGARCH-ged-skew
  class_<sGARCH_sged>("sGARCH_sged")
      .constructor()
      .field("name", &sGARCH_sged::name)
      .field("theta0", &sGARCH_sged::theta0)
      .field("Sigma0", &sGARCH_sged::Sigma0)
      .field("label", &sGARCH_sged::label)
      .field("lower", &sGARCH_sged::lower)
      .field("upper", &sGARCH_sged::upper)
      .field("ineq_lb", &sGARCH_sged::ineq_lb)
      .field("ineq_ub", &sGARCH_sged::ineq_ub)
      .field("NbParams", &sGARCH_sged::NbParams)
      .field("NbParamsModel", &sGARCH_sged::NbParamsModel)
      .method("f_sim", &sGARCH_sged::f_sim)
      .method("f_pdf", &sGARCH_sged::f_pdf)
      .method("f_pdf_its", &sGARCH_sged::f_pdf_its)
      .method("f_cdf", &sGARCH_sged::f_cdf)
      .method("f_cdf_its", &sGARCH_sged::f_cdf_its)
      .method("f_simAhead", &sGARCH_sged::f_simAhead)
      .method("f_get_sd", &sGARCH_sged::get_sd)
      .method("f_set_sd", &sGARCH_sged::set_sd)
      .method("f_get_mean", &sGARCH_sged::get_mean)
      .method("f_set_mean", &sGARCH_sged::set_mean)
      .method("f_rnd", &sGARCH_sged::f_rnd)
      .method("calc_ht", &sGARCH_sged::calc_ht)
      .method("eval_model", &sGARCH_sged::eval_model)
      .method("ineq_func", &sGARCH_sged::ineq_func)
      .method("f_unc_vol", &sGARCH_sged::f_unc_vol);
}
