% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{plot.data_descr}
\alias{plot.data_descr}
\title{Plot descriptive statistics for partial rankings}
\usage{
\method{plot}{data_descr}(
  x,
  cex_text_mean = 1,
  cex_symb_mean = 12,
  marg_by = "item",
  cex_text_pc = 3,
  cex_range_pc = c(8, 20),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"data_descr"} returned by \code{\link{data_description}}.}

\item{cex_text_mean}{Positive scalar: the magnification to be used for all the labels in the plot for the mean rank vector. Defaults to 1.}

\item{cex_symb_mean}{Positive scalar: the magnification to be used for the symbols in the pictogram of the mean rank vector. Defaults to 12.}

\item{marg_by}{Character indicating whether the marginal distributions must be reported by \code{"item"} or by \code{"rank"} in the heatmap. Defaults to \code{"item"}.}

\item{cex_text_pc}{Positive scalar: the magnification to be used for all the labels in the bubble plot of the paired comparison frequencies. Defaults to 3.}

\item{cex_range_pc}{Numeric vector indicating the range of values to be used on each axis in the bubble plot of the paired comparison frequencies. Defaults to \code{c(8,20)}.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
A list of 5 labelled plots displaying descriptive summaries of the partial ranking dataset, namely: i) \code{n_ranked_distr}: a barplot of the frequency distribution (\%) of the number of items actually ranked in each partial sequence, ii) \code{picto_mean_rank}: a basic pictogram of the mean rank vector, iii) \code{marginals}: a heatmap of the marginal distributions (either by item or by rank), iv) \code{ecdf}: the ecdf of the marginal rank distributions and v) \code{pc}: a bubble plot of the pairwise comparison matrix.
}
\description{
\code{plot} method for class \code{"data_descr"}.
}
\details{
The plots of the marginals distributions and pairwise comparisons are constructed if the object \code{x} was obtained from the \code{data_description} routine with arguments \code{marg = TRUE} and \code{pc = TRUE}; otherwise, a \code{NULL} element in the output list is returned.
}
\examples{

## Example 1. Plot the mean rank vector and marginal distributions for the Antifragility dataset.
r_antifrag <- ranks_antifragility[, 1:7]
desc <- data_description(r_antifrag)
p_desc <- plot(desc)
p_desc$picto_mean_rank()
p_desc$marginals()

## Example 2. Plot the distribution of the number of ranked items and the
# pairwise comparison matrix for the Sports dataset.
r_sports <- ranks_sports[, 1:8]
desc <- data_description(rankings = r_sports, borda_ord = TRUE)
p_desc <- plot(desc, cex_text_mean = 1.2)
p_desc$n_ranked_distr()
p_desc$pc()

## Example 3. Plot the ecdf's for the marginal rank distributions for the Sports dataset by gender.
r_sports <- ranks_sports[, 1:8]
desc_f <- data_description(rankings = r_sports, subset = (ranks_sports$Gender == "Female"))
p_desc_f <- plot(desc_f, cex_text_mean = 1.2)
p_desc_f$ecdf()
desc_m <- data_description(rankings = r_sports, subset = (ranks_sports$Gender == "Male"))
p_desc_m <- plot(desc_m, cex_text_mean = 1.2)
p_desc_m$ecdf()


}
\references{
Wickham H (2016). ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York. ISBN 978-3-319-24277-4, \url{https://ggplot2.tidyverse.org}.
}
\seealso{
\code{\link{data_description}}
}
