% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spmsDx.R
\name{spmsDx}
\alias{spmsDx}
\title{Diagnosis of secondary progressive multiple sclerosis}
\usage{
spmsDx(
  visits,
  minEDSS = 4,
  minFSpyr = 2,
  tRelapse = 30,
  tProgression = 3 * 30.25,
  tRegression = 9 * 30.25,
  tRelProg = 6 * 30.25
)
}
\arguments{
\item{visits}{A data frame consisting of 12 columns: ID, dateEDSS, EDSS, FSpyr (pyramidal FSS), FScrbl (Cerebellar FSS), FSbstem (Brainstem FSS), FSsens (Sensory FSS), FSsph (Bowel Bladder FSS), FSvis (Visual FSS), FScereb (Cerebral FSS), FSamb (Ambulation score), daysPostRelapse (days since most recent relapse).}

\item{minEDSS}{Minimum EDSS score to reach SPMS conversion.}

\item{minFSpyr}{Minimum pyramidal FSS to reach SPMS conversion.}

\item{tRelapse}{Minimum time in days from prior relapse to confirmation of EDSS progression.}

\item{tProgression}{SPMS confirmation period in days.}

\item{tRegression}{Confirmation period for EDSS improvement in days.}

\item{tRelProg}{Confirmation period (days) for rebaselining EDSS (after a relapse led to non-confirmed increase in EDSS).}
}
\value{
A data frame.
}
\description{
Diagnosis of conversion from relapsing-remitting multiple sclerosis (RRMS) to secondary progressive multiple sclerosis (SPMS), using the CORe definition, including Functional System Scores (FSS) of Expanded Disability Status Scale (EDSS). Diagnosis is based on clinical visit records, each record including entries for patient code, visit date, EDSS score, FSS, ambulation score, and days since most recent relapse.
}
\examples{
data(SampleData)
output<-spmsDx(SampleData)
}
\references{
Lorscheider J, et al. Brain 2016; 139 (9): 2395-2405.
}
