% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_bidev.R
\name{map_bidev}
\alias{map_bidev}
\title{Map Multiscalar Typology (2 deviations)}
\usage{
map_bidev(x, dev1, dev2, breaks = c(25, 50, 100), xid = NULL)
}
\arguments{
\item{x}{A sf object including a variable resulting from the mst function.}

\item{dev1}{column name of the first relative deviation in x.}

\item{dev2}{coumn name of the second relative deviation in x.}

\item{breaks}{Distance to the index 100 (average of the context), in
percentage. A vector of three values. Defaut c(25,50,100). 25 % corresponds
to indexes 80 and 125. 50 % to indexes 67 and 150 and 100 % to indexes 50 
and 200.}

\item{xid}{identifier field in x. Default the first column.}
}
\value{
A list including a ordered sf object for mapping mst column (geom) and 
a vector of suggested colors (cols). 
\itemize{bidev typology values :
\item{ZZ: Near the average for the two selected deviation}
\item{A1: Above the average for dev1 and dev2, distance to the avarage : +}
\item{A2: Above the average for dev1 and dev2, distance to the avarage : ++}
\item{A3: Above the average for dev1 and dev2, distance to the avarage : +++}
\item{B1: Above the average for dev1 and below for dev2, distance to the
 avarage : +}
\item{B2: Above the average for dev1 and below for dev2, distance to the
 avarage : ++}
\item{B3: Above the average for dev1 and below for dev2, distance to the
 avarage : +++}
\item{C1: Below the average for dev1 and dev2, distance to the avarage : +}
\item{C2: Below the average for dev1 and dev2, distance to the avarage : ++}
\item{C3: Below the average for dev1 and dev2, distance to the avarage : +++}
\item{D1: Below the average for dev1 and above for dev2, distance to the
 avarage : +}
\item{D2: Below the average for dev1 and above for dev2, distance to the
 avarage : ++}
\item{D3: Below the average for dev1 and above for dev2, distance to the
 avarage : +++}
}
}
\description{
Compute the multiscalar typology (2 deviations) and propose 
colors for mapping the results.
}
\examples{
# Focus on exceptional values (50, 100 and 200 \% above-under the average)
# load data
data("GrandParisMetropole")

# Prerequisite  - Compute 2 deviations
com$gdev <- gdev(x = com, var1 = "INC", var2 = "TH")
com$tdev <- tdev(x = com, var1 = "INC", var2 = "TH", key = "EPT")

# Compute map_bidev
bidev <- map_bidev(x = com, dev1 = "gdev", dev2 = "tdev", breaks = c(50, 100, 200))

# Unlist resulting function
com <- bidev$geom
cols <- bidev$cols

# Visualization 
library(cartography)
library(sf)

# One side for the map, another for the plot
par(mfrow = c(1,2), mar = c(0,4,0,0))

# Cartography
typoLayer(x = com, var = "bidev", border = "grey50", col = cols, lwd = 0.2, 
          legend.pos = "n")
plot(ept$geometry, col = NA, lwd = 1, add = TRUE)

# Label territories in the C3 category
labelLayer(x = com[com$bidev == "C3",], txt = "LIBCOM", halo = TRUE)

layoutLayer(title = "2-Deviations synthesis : general and territorial contexts",
            author = "MTA, 2020", scale = 5, col = "white", coltitle = "black")

# Add plot_bidev on the right side of the map
plot_bidev(x = com,  dev1 = "gdev",  dev2 = "tdev", 
           dev1.lab = "General deviation (MGP Area)",
           dev2.lab = "Territorial deviation (EPT of belonging)",
           breaks = c(50, 100, 200),
           lib.var = "LIBCOM", lib.val = "Clichy-sous-Bois", cex.lab = 0.8)
}
