% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_C50Model.R
\name{C50Model}
\alias{C50Model}
\title{C5.0 Decision Trees and Rule-Based Model}
\usage{
C50Model(
  trials = 1,
  rules = FALSE,
  subset = TRUE,
  bands = 0,
  winnow = FALSE,
  noGlobalPruning = FALSE,
  CF = 0.25,
  minCases = 2,
  fuzzyThreshold = FALSE,
  sample = 0,
  earlyStopping = TRUE
)
}
\arguments{
\item{trials}{integer number of boosting iterations.}

\item{rules}{logical indicating whether to decompose the tree into a
rule-based model.}

\item{subset}{logical indicating whether the model should evaluate groups of
discrete predictors for splits.}

\item{bands}{integer between 2 and 1000 specifying a number of bands into
which to group rules ordered by their affect on the error rate.}

\item{winnow}{logical indicating use of predictor winnowing (i.e. feature
selection).}

\item{noGlobalPruning}{logical indicating a final, global pruning step to
simplify the tree.}

\item{CF}{number in (0, 1) for the confidence factor.}

\item{minCases}{integer for the smallest number of samples that must be put
in at least two of the splits.}

\item{fuzzyThreshold}{logical indicating whether to evaluate possible
advanced splits of the data.}

\item{sample}{value between (0, 0.999) that specifies the random proportion
of data to use in training the model.}

\item{earlyStopping}{logical indicating whether the internal method for
stopping boosting should be used.}
}
\value{
\code{MLModel} class object.
}
\description{
Fit classification tree models or rule-based models using Quinlan's C5.0
algorithm.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{trials}, \code{rules}, \code{winnow}
  }
}

Latter arguments are passed to \code{\link[C50]{C5.0Control}}.
Further model details can be found in the source link below.

In calls to \code{\link{varimp}} for \code{C50Model}, argument \code{type}
may be specified as \code{"usage"} (default) for the percentage of training
set samples that fall into all terminal nodes after the split of each
predictor or as \code{"splits"} for the percentage of splits associated with
each predictor.  Variable importance is automatically scaled to range from 0
to 100.  To obtain unscaled importance values, set \code{scale = FALSE}.  See
example below.
}
\examples{
\donttest{
## Requires prior installation of suggested package C50 to run

model_fit <- fit(Species ~ ., data = iris, model = C50Model)
varimp(model_fit, type = "splits", scale = FALSE)
}

}
\seealso{
\code{\link[C50]{C5.0}}, \code{\link{fit}}, \code{\link{resample}}
}
