% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_points.R
\name{clean_points}
\alias{clean_points}
\title{Clean occurrence records}
\usage{
clean_points(coord, merge_dist, coord_col = c("Lon", "Lat"),
  filter_layer = NULL, na.rm = FALSE)
}
\arguments{
\item{coord}{data.frame. Data frame containing longitudes (Lon) and latitudes (Lat) of occurrence records of a species.}

\item{merge_dist}{numeric. Maximum distance between points to be merged, in meters.}

\item{coord_col}{vector of strings or integers. If x has more than two columns, indicate the name or position of longitude and latitude columns}

\item{filter_layer}{RasterLayer. Binary raster with 1 representing the regions where records should be kept and 0 the regions where they should be eliminated.}

\item{na.rm}{logical. if TRUE, remove lines with NA in any coordinate.}
}
\value{
Data frame with remaining longitudes and latitudes.
}
\description{
\code{clean_points} Eliminates species occurrence records that are too close to each other or at undesired locations.
}
\examples{
 TtorquatusDistribution_clean <-
  clean_points(coord = TtorquatusDistribution,
               merge_dist = 20000,
               filter_layer = !is.na(df_alt))

}
