% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMWRsites.R
\name{readMWRsites}
\alias{readMWRsites}
\title{Read site metadata from an external file}
\usage{
readMWRsites(sitpth, runchk = TRUE)
}
\arguments{
\item{sitpth}{character string of path to the site metadata file}

\item{runchk}{logical to run data checks with \code{\link{checkMWRsites}}}
}
\value{
A formatted data frame of site metadata that can be used for downstream analysis
}
\description{
Read site metadata from an external file
}
\details{
Data are imported with \code{\link[readxl]{read_excel}} and checked with \code{\link{checkMWRsites}}.
}
\examples{
sitpth <- system.file('extdata/ExampleSites.xlsx', package = 'MassWateR')

sitdat <- readMWRsites(sitpth)
head(sitdat)
}
