% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lechner-SE.R
\name{lechner_se}
\alias{lechner_se}
\title{Lechner's Standard Error for the ATT}
\usage{
lechner_se(obj, Y)
}
\arguments{
\item{obj}{MatchIt Object}

\item{Y}{Response Vector}
}
\value{
SE for the ATT of \code{Y}
}
\description{
Calculates the Standard Error for the  Average Treatment Effect with Lechner's
method.
}
\examples{
\dontrun{
  library(MatchIt)
  data("lalonde")
  m.out  <- matchit(treat ~ educ + black, data = lalonde)
  att(obj = m.out, Y = lalonde$re78)
  lechner_se(obj = m.out, Y = lalonde$re78)
}
}
\references{
Lechner, M. (2001). Identification and estimation of causal effects of multiple treatments under the conditional indepence assumption. In M. Lechner & F. Pfeiffer (Eds.), Econometric Evaluation of Labour Market Policies (pp. 43-58). Physica-Verlag: Heidelberg.
}

