% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Naive-SE.R
\name{zelig_se}
\alias{zelig_se}
\title{Parametric bootstrap Standard Error for the ATT}
\usage{
zelig_se(obj, Y)
}
\arguments{
\item{obj}{MatchIt Object}

\item{Y}{Response Vector}
}
\value{
SE for the ATT of \code{Y}
}
\description{
Calculates the Standard Error for the  Average Treatment Effect with a
a parametric bootstrap method.
This procedure mimics the output of the zelig packages as shown
on pages 12 and 13 in the MatchIt vignette.
}
\examples{
\dontrun{
  library(MatchIt)
  data("lalonde")
  m.out  <- matchit(treat ~ educ + black, data = lalonde)
  att(obj = m.out, Y = lalonde$re78)
  zelig_se(obj = m.out, Y = lalonde$re78)
}
}
\references{
\href{http://imai.princeton.edu/research/files/matchit.pdf}{MatchIt vignette}
}

