% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightthem.data.R
\name{weightthem.data}
\alias{weightthem.data}
\title{Outputs Weighted Imputed Datasets}
\usage{
weightthem.data(object, n = 1)
}
\arguments{
\item{object}{This argument specifies an object of the \code{wimids} class.}

\item{n}{This argument specifies the weighted imputed dataset number, intended to extract its data. The input must be a positive integer. The default is \code{1}.}
}
\value{
This function returns the imputed dataset after weighting, with weights of observations included in the dataset (listed as the \code{weights} variables).
}
\description{
The \code{weightthem.data()} function extracts data from an object of the \code{wimids} class.
}
\details{
The weighted datasets within the \code{wimids} class object are extracted.
}
\examples{
\donttest{
#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg", "logreg", "logreg", "logreg"))

#Estimating weights of observations in the multiply imputed datasets
weighted.datasets <- weightthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                                approach = 'within', method = 'ps')

#Extracting the first imputed dataset
weighted.dataset.1 <- weightthem.data(weighted.datasets, n = 1)
}
}
\seealso{
\code{\link[=wimids]{wimids}}
}
\author{
Farhad Pishgar
}
