% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_addOpenCageInfo.R
\name{table_addOpenCageInfo}
\alias{table_addOpenCageInfo}
\title{Add address fields to a known location table}
\usage{
table_addOpenCageInfo(
  locationTbl = NULL,
  replaceExisting = FALSE,
  retainOpenCage = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{replaceExisting}{Logical specifying whether to replace existing data
with data obtained from OpenCage.}

\item{retainOpenCage}{Logical specifying whether to retain all fields obtained
from OpenCage, each named with a prefix of \code{opencage_}.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Tibble of "known locations" enhanced with information from the
OpenCage reverse geocoding service.
}
\description{
The OpenCage reverse geocoding service is used to update an
existing table. Updated columns include:

\itemize{
\item{countryCode}
\item{stateCode}
\item{countyName}
\item{timezone}
\item{houseNumber}
\item{street}
\item{city}
\item{zip}
\item{address}
}

When \code{replaceExisting = TRUE}, all existing address fields are discarded
in favor of the OpenCage versions. To only fill in missing values in
\code{locationTbl}, use \code{replaceExisting = FALSE}.

The OpenCage service returns a large number of fields, some of which may be
useful. To add all OpenCage fields to a location table, use
\code{retainOpenCage = TRUE}. This will append 78+ fields of information,
each each named with a prefix of \code{"opencage_"}.
}
\note{
The OpenCage service requires an API key which can be obtained from
their web site. This API key must be set as an environment variable with:

\preformatted{
Sys.setenv("OPENCAGE_KEY" = "<your api key>")
}

Parameters are set for use at the OpenCage "free trial" level which allows
for 1 request/sec and a maximum of 2500 requests per day.

Because of the 1 request/sec default, it is recommended that
\code{table_addOpenCageInfo()} only be used in an interactive session when
updating a table with a large number of records.
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

myTbl <- id_monitors_500[1:3,]
myTbl$countryCode[1] <- NA
myTbl$countryCode[2] <- "WRONG"
myTbl$countyName[3] <- "WRONG"
myTbl$timezone <- NA

dplyr::glimpse(myTbl)

Sys.setenv("OPENCAGE_KEY" = "<YOUR_KEY>")

table_addOpenCageInfo(myTbl) \%>\% 
  dplyr::glimpse()

table_addOpenCageInfo(myTbl, replaceExisting = TRUE) \%>\% 
  dplyr::glimpse()

table_addOpenCageInfo(myTbl, replaceExisting = TRUE, retainOpenCage = TRUE) \%>\% 
  dplyr::glimpse()
  
}, silent = FALSE)
}
}
\references{
\url{https://opencagedata.com}
}
