% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_getDistanceFromTarget.R
\name{table_getDistanceFromTarget}
\alias{table_getDistanceFromTarget}
\title{Return distances and directions from a target location to known locations}
\usage{
table_getDistanceFromTarget(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  measure = c("geodesic", "haversine", "vincenty", "cheap")
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Target longitude in decimal degrees E.}

\item{latitude}{Target latitude in decimal degrees N.}

\item{measure}{One of "geodesic", "haversine", "vincenty" or "cheap"
specifying desired method of geodesic distance calculation.}
}
\value{
Tibble of distances in meters and cardinal directions from a target location.
}
\description{
Returns a tibble with the same number of rows as \code{locationTbl}
containing the distance and direction from the target location specified by
\code{longitude} and \code{latitude} to each known location found in
\code{locationTbl}.
}
\note{
Only a single target location is allowed.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))

locationTbl \%>\%
  table_getDistanceFromTarget(
    longitude = -117.3647, 
    latitude = 47.6725
  ) \%>\% 
  dplyr::glimpse()

}
