% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getVariable.R
\name{getVariable}
\alias{getVariable}
\title{Return SpatialDataframe Variable at Specified Locations}
\usage{
getVariable(lon, lat, dataset = NULL, variable = NULL,
  countryCodes = NULL, allData = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use}

\item{variable}{name of dataframe column to be returned}

\item{countryCodes}{vector of countryCodes -- defaults to \code{NULL}}

\item{allData}{logical specifying whether a full dataframe should be returned}
}
\value{
Vector or dataframe.
}
\description{
Uses spatial comparison to determine which polygons the
    locations fall into and returns the variable associated with those polygons.

    If \code{allData=TRUE}, the entire dataframe is returned.
}
\examples{
\dontrun{
loadSpatialData('NaturalEarthAdm1')
lon <- seq(0,50)
lat <- seq(0,50)
getVariable(lon,lat,'NaturalEarthAdm1','gns_lang')
}
}
\seealso{
getSpatialData
}
\keyword{locator}

