% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MazamaSpatialUtils.R
\name{stateToCode}
\alias{stateToCode}
\title{Convert state names to state codes}
\usage{
stateToCode(stateNames, countryCodes = NULL, dataset = "NaturalEarthAdm1")
}
\arguments{
\item{stateNames}{Vector of state names to be converted.}

\item{countryCodes}{Vector of ISO 3166-2 alpha-2 country codes the state might be found in.}

\item{dataset}{Name of dataset containing state-level identifiers.}
}
\value{
A vector of ISO 3166-2 codes or NA.
}
\description{
Converts a vector of state names to an ISO 3166-2 two character
state codes.
}
\details{
For this function to work, you must install and load the
"NaturalEarthAdm1" dataset.
}
\examples{
\dontrun{
stateToCode("Washington")
stateToCode("Barcelona")
stateToCode("Shandong")
}
}
\seealso{
convertNaturalEarthAdm1
}
