% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_combine.R
\name{mts_combine}
\alias{mts_combine}
\title{Combine multiple \emph{mts} time series objects}
\usage{
mts_combine(..., replaceMeta = FALSE)
}
\arguments{
\item{...}{Any number of valid \emph{mts} objects.}

\item{replaceMeta}{Logical specifying whether to allow replacement of
metadata associated with \code{deviceDeploymentIDs}.}
}
\value{
An \emph{mts} time series object containing all time series found
in the incoming \code{mts} objects.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Create a combined \emph{mts} from any number of \emph{mts}
objects or from a list of \emph{mts} objects. The resulting \emph{mts}
object with contain all \code{deviceDeploymentIDs} found in any incoming
\emph{mts} and will have a regular time axis covering the the entire range
of incoming data.

If incoming time ranges are non-contiguous, the resulting \emph{mts} will
have gaps filled with \code{NA} values.

An error is generated if the incoming \emph{mts} objects have
non-identical metadata for the same \code{deviceDeploymentID} unless
\code{replaceMeta = TRUE}.
}
\note{
Data for any \code{deviceDeploymentIDs} shared among \emph{mts}
objects are combined with a "later is better" sensibility where any
data overlaps exist. To handle this, incoming \emph{mts} objects are first
split into "shared" and "unshared" parts.

Any "shared" parts are ordered based on the
time stamp of their last record. Then \code{dplyr::distinct()} is used to
remove records with duplicate \code{datetime} fields. Any data records found
in "later" \emph{mts} objects are preferentially retained before the "shared"
data are finally reordered by ascending \code{datetime}.

The final step is combining the "shared" and "unshared" parts and placing
them on a uniform time axis.
}
\examples{
library(MazamaTimeSeries)

ids1 <- example_mts$meta$deviceDeploymentID[1:5]
ids2 <- example_mts$meta$deviceDeploymentID[4:6]
ids3 <- example_mts$meta$deviceDeploymentID[8:10]

mts1 <-
  example_mts \%>\%
  mts_filterMeta(deviceDeploymentID \%in\% ids1) \%>\%
  mts_filterDate(20190701, 20190703)

mts2 <-
  example_mts \%>\%
  mts_filterMeta(deviceDeploymentID \%in\% ids2) \%>\%
  mts_filterDate(20190704, 20190706)

mts3 <-
  example_mts \%>\%
  mts_filterMeta(deviceDeploymentID \%in\% ids3) \%>\%
  mts_filterDate(20190705, 20190708)

mts <- mts_combine(mts1, mts2, mts3)

# Should have 1:6 + 8:10 = 9 meta records and the full date range
nrow(mts$meta)
range(mts$data$datetime)

}
