% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Meiosis.R, R/RcppExports.R
\name{calc_Lstar}
\alias{calc_Lstar}
\alias{calc_Lstar}
\title{Calculate adjusted chromosome length for obligate chiasma}
\usage{
calc_Lstar(L, m, p, epsilon = NULL)
}
\arguments{
\item{L}{Double. Length of the chromosome in cM. Must be > 50.}

\item{m}{Integer. Interference parameter for chi-square model. Must be non-negative.}

\item{p}{Double. Proportion of chiasmata coming from no-interference process}

\item{epsilon}{Double. The precision for finding the adjusted chromosome length.
Defaults to \code{NULL}, where a "high" precision is used.}
}
\value{
Double. Adjusted chromosome length.
}
\description{
This function is an R-wrapper of an underlying C++ routine.
It is not intended for direct usage, but exposed for completeness.

Calculate the reduced chromosome length that will give the target
expected number of chiasmata when conditioning on there being at
least one chiasma on the four-strand bundle.
}
\examples{
Meiosis::calc_Lstar(100, 0, 0)
Meiosis::calc_Lstar(60, 10, 0.1)

}
