\name{get_mesh_info}
\alias{get_mesh_info}
\title{Get information about a list of oberver/mesh objects}
\description{Get key information about a list of observer/mesh objects. This includes the respective number of vertices and triangles of the meshes as well as their volume and centroid.}
\usage{
get_mesh_info(x)
}
\arguments{
  \item{x}{\code{list} of observer/mesh objects with a structure as generated by \code{\link[MeshAgreement]{read_mesh}}.}
}
\details{Use \code{\link[MeshAgreement]{get_mesh_info_one}} for getting the information about a single mesh object. Use \code{\link[MeshAgreement]{get_mesh_info_obs}} for getting the information about a list of meshes.}
\value{
\code{data.frame} with these variables
\item{observer}{Name of the observer.}
\item{name}{Name of the mesh.}
\item{n_verts}{Number of vertices.}
\item{n_faces}{Number of faces.}
\item{volume}{Mesh volume.}
\item{ctr_x}{Centroid x-coordinate.}
\item{ctr_y}{Centroid y-coordinate.}
\item{ctr_z}{Centroid z-coordinate.}
}
\seealso{
\code{\link[MeshAgreement]{read_mesh}},
\code{\link[MeshAgreement]{get_mesh_info_one}},
\code{\link[MeshAgreement]{get_mesh_info_obs}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
get_mesh_info(heartL)
}
