% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convexPartsR.R
\name{convexParts}
\alias{convexParts}
\title{Decomposition into convex parts}
\usage{
convexParts(vertices, faces, mesh = NULL, triangulate = TRUE)
}
\arguments{
\item{vertices}{a numeric matrix with three columns, or a \code{bigq}
matrix with three columns if \code{numbersType="gmp"}}

\item{faces}{either an integer matrix (each row provides the vertex indices
of the corresponding face) or a list of integer vectors, each one
providing the vertex indices of the corresponding face}

\item{mesh}{if not \code{NULL}, this argument takes precedence over
\code{vertices} and \code{faces}, and must be either a list containing
the fields \code{vertices} and \code{faces} (objects as described above),
otherwise a \strong{rgl} mesh (i.e. a \code{mesh3d} object)}

\item{triangulate}{Boolean, whether to triangulate the convex parts}
}
\value{
A list of \code{cgalMesh} lists, each corresponding to a convex part.
}
\description{
Decomposition of a mesh into convex parts.
}
\examples{
# a non-convex polyhedron ####
\donttest{library(MeshesOperations)
library(rgl)
library(randomcoloR)
meshes <- convexParts(mesh = NonConvexPolyhedron)
ncp <- length(meshes)
colors <- randomColor(ncp, hue = "random", luminosity = "bright")
open3d(windowRect = c(50, 50, 562, 562), zoom = 0.8)
for(i in seq_len(ncp)){
  shade3d(toRGL(meshes[[i]]), color = colors[i])
}
plotEdges(
  NonConvexPolyhedron[["vertices"]],
  NonConvexPolyhedron[["edges"]]
)}

# pentagrammic prism ####
\donttest{library(MeshesOperations)
library(rgl)
library(randomcoloR)
meshes <- convexParts(mesh = pentagrammicPrism)
ncp <- length(meshes)
colors <- randomColor(ncp, hue = "random", luminosity = "bright")
open3d(windowRect = c(50, 50, 562, 562), zoom = 0.8)
for(i in seq_len(ncp)){
  shade3d(toRGL(meshes[[i]]), color = colors[i])
}
plotEdges(
  pentagrammicPrism[["vertices"]],
  pentagrammicPrism[["edges"]],
  tubesRadius = 0.01,
  spheresRadius = 0.02
)}
}
