% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{meshVolume}
\alias{meshVolume}
\title{Mesh volume}
\usage{
meshVolume(mesh)
}
\arguments{
\item{mesh}{a mesh given either as a list containing (at least) the two fields 
\code{vertices} (numeric matrix with three columns) and \code{faces} (integer 
matrix or list of integer vectors), otherwise as a \strong{rgl} mesh (i.e. a 
\code{mesh3d} object)}
}
\value{
A number, the volume bounded by the mesh.
}
\description{
Computes the volume bounded by a mesh.
}
\examples{
library(MeshesOperations)
R <- 4; r <- 2
mesh <- torusMesh(R, r)
meshVolume(mesh)
# true volume of the torus: 
2 * pi^2 * R * r^2
}
