% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/someMeshes.R
\name{torusMesh}
\alias{torusMesh}
\title{Torus mesh}
\usage{
torusMesh(R, r, nu = 50, nv = 30)
}
\arguments{
\item{R, r}{major and minor radii, positive numbers}

\item{nu, nv}{numbers of subdivisions, integers (at least 3)}
}
\value{
A triangle \strong{rgl} mesh (class \code{mesh3d}).
}
\description{
Triangle mesh of a torus.
}
\examples{
library(MeshesTools)
library(rgl)
mesh <- torusMesh(R = 3, r = 1)
open3d(windowRect = c(50, 50, 562, 562))
view3d(0, 0, zoom = 0.75)
shade3d(mesh, color = "green")
wire3d(mesh)
}
