% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolites_methods.R
\name{filterMetabolites}
\alias{filterMetabolites}
\alias{filterMetabolites,MetAlyzer-method}
\title{Filter metabolites}
\usage{
filterMetabolites(
  object,
  class_name = "Metabolism Indicators",
  metabo_vec = NULL
)

\S4method{filterMetabolites}{MetAlyzer}(
  object,
  class_name = "Metabolism Indicators",
  metabo_vec = NULL
)
}
\arguments{
\item{object}{MetAlyzer object}

\item{class_name}{A character value defining the class to be removed}

\item{metabo_vec}{A character vector defining metabolites to be removed}
}
\value{
An updated MetAlyzer object
}
\description{
This method filters out certain classes or metabolites of the metabolites
vector.
}
\details{
Note: If both "metabo_vec" and "class_name" arguments are used "metabo_vec"
overwrites the "class_name" argument!
}
\section{Methods (by class)}{
\itemize{
\item \code{MetAlyzer}: Filter metabolites
}}

\examples{
fpath <- system.file("extdata", "example_data.xlsx", package = "MetAlyzer")
obj <- MetAlyzerDataset(file_path = fpath)

obj <- filterMetabolites(obj, class_name = "Metabolism Indicators")
# or
obj <- filterMetabolites(obj, metabo_vec = c("C0", "C2", "C3"))
}
