% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_search.R
\name{searchMZonline}
\alias{searchMZonline}
\title{Find m/z matches with CMMR, ChemSpider or PubChem}
\usage{
searchMZonline(
  mz = 178.1219,
  mode = "positive",
  adducts,
  ppm = 2,
  which_db = "cmmr",
  apikey = ""
)
}
\arguments{
\item{mz}{M/z of interest, Default: 178.1219}

\item{mode}{Is m/z positive or negative mode?, Default: 'positive'}

\item{adducts}{Which adducts will you consider (for cmmr only)}

\item{ppm}{Allowed error margin in parts per million, Default: 2}

\item{which_db}{Which online database do you want to search?, Default: 'cmmr'}

\item{apikey}{ChemSpider API key. Only required if searching in ChemSpider.}
}
\value{
Table with match information
}
\description{
Wrapper function for all online searches.
}
\examples{
\dontrun{searchMZonline(mz = 170.09240307, mode = "positive", which_db = "cmmr")}
}
\seealso{
\code{\link[pbapply]{pbapply}}
}
